// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.IotFirmwareDefense.Models
{
    public partial class CryptoCertificateResult : IUtf8JsonSerializable, IJsonModel<CryptoCertificateResult>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<CryptoCertificateResult>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<CryptoCertificateResult>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CryptoCertificateResult>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CryptoCertificateResult)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(CryptoCertId))
            {
                if (CryptoCertId != null)
                {
                    writer.WritePropertyName("cryptoCertId"u8);
                    writer.WriteStringValue(CryptoCertId);
                }
                else
                {
                    writer.WriteNull("cryptoCertId");
                }
            }
            if (Optional.IsDefined(NamePropertiesName))
            {
                if (NamePropertiesName != null)
                {
                    writer.WritePropertyName("name"u8);
                    writer.WriteStringValue(NamePropertiesName);
                }
                else
                {
                    writer.WriteNull("name");
                }
            }
            if (Optional.IsDefined(Subject))
            {
                if (Subject != null)
                {
                    writer.WritePropertyName("subject"u8);
                    writer.WriteObjectValue(Subject, options);
                }
                else
                {
                    writer.WriteNull("subject");
                }
            }
            if (Optional.IsDefined(Issuer))
            {
                if (Issuer != null)
                {
                    writer.WritePropertyName("issuer"u8);
                    writer.WriteObjectValue(Issuer, options);
                }
                else
                {
                    writer.WriteNull("issuer");
                }
            }
            if (Optional.IsDefined(IssuedOn))
            {
                if (IssuedOn != null)
                {
                    writer.WritePropertyName("issuedDate"u8);
                    writer.WriteStringValue(IssuedOn.Value, "O");
                }
                else
                {
                    writer.WriteNull("issuedDate");
                }
            }
            if (Optional.IsDefined(ExpireOn))
            {
                if (ExpireOn != null)
                {
                    writer.WritePropertyName("expirationDate"u8);
                    writer.WriteStringValue(ExpireOn.Value, "O");
                }
                else
                {
                    writer.WriteNull("expirationDate");
                }
            }
            if (Optional.IsDefined(Role))
            {
                if (Role != null)
                {
                    writer.WritePropertyName("role"u8);
                    writer.WriteStringValue(Role);
                }
                else
                {
                    writer.WriteNull("role");
                }
            }
            if (Optional.IsDefined(SignatureAlgorithm))
            {
                if (SignatureAlgorithm != null)
                {
                    writer.WritePropertyName("signatureAlgorithm"u8);
                    writer.WriteStringValue(SignatureAlgorithm);
                }
                else
                {
                    writer.WriteNull("signatureAlgorithm");
                }
            }
            if (Optional.IsDefined(KeySize))
            {
                if (KeySize != null)
                {
                    writer.WritePropertyName("keySize"u8);
                    writer.WriteNumberValue(KeySize.Value);
                }
                else
                {
                    writer.WriteNull("keySize");
                }
            }
            if (Optional.IsDefined(KeyAlgorithm))
            {
                if (KeyAlgorithm != null)
                {
                    writer.WritePropertyName("keyAlgorithm"u8);
                    writer.WriteStringValue(KeyAlgorithm);
                }
                else
                {
                    writer.WriteNull("keyAlgorithm");
                }
            }
            if (Optional.IsDefined(Encoding))
            {
                if (Encoding != null)
                {
                    writer.WritePropertyName("encoding"u8);
                    writer.WriteStringValue(Encoding);
                }
                else
                {
                    writer.WriteNull("encoding");
                }
            }
            if (Optional.IsDefined(SerialNumber))
            {
                if (SerialNumber != null)
                {
                    writer.WritePropertyName("serialNumber"u8);
                    writer.WriteStringValue(SerialNumber);
                }
                else
                {
                    writer.WriteNull("serialNumber");
                }
            }
            if (Optional.IsDefined(Fingerprint))
            {
                if (Fingerprint != null)
                {
                    writer.WritePropertyName("fingerprint"u8);
                    writer.WriteStringValue(Fingerprint);
                }
                else
                {
                    writer.WriteNull("fingerprint");
                }
            }
            if (Optional.IsCollectionDefined(Usage))
            {
                if (Usage != null)
                {
                    writer.WritePropertyName("usage"u8);
                    writer.WriteStartArray();
                    foreach (var item in Usage)
                    {
                        writer.WriteStringValue(item);
                    }
                    writer.WriteEndArray();
                }
                else
                {
                    writer.WriteNull("usage");
                }
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(FilePaths))
            {
                if (FilePaths != null)
                {
                    writer.WritePropertyName("filePaths"u8);
                    writer.WriteStartArray();
                    foreach (var item in FilePaths)
                    {
                        writer.WriteStringValue(item);
                    }
                    writer.WriteEndArray();
                }
                else
                {
                    writer.WriteNull("filePaths");
                }
            }
            if (Optional.IsDefined(PairedKey))
            {
                if (PairedKey != null)
                {
                    writer.WritePropertyName("pairedKey"u8);
                    writer.WriteObjectValue(PairedKey, options);
                }
                else
                {
                    writer.WriteNull("pairedKey");
                }
            }
            if (Optional.IsDefined(IsExpired))
            {
                if (IsExpired != null)
                {
                    writer.WritePropertyName("isExpired"u8);
                    writer.WriteBooleanValue(IsExpired.Value);
                }
                else
                {
                    writer.WriteNull("isExpired");
                }
            }
            if (Optional.IsDefined(IsSelfSigned))
            {
                if (IsSelfSigned != null)
                {
                    writer.WritePropertyName("isSelfSigned"u8);
                    writer.WriteBooleanValue(IsSelfSigned.Value);
                }
                else
                {
                    writer.WriteNull("isSelfSigned");
                }
            }
            if (Optional.IsDefined(IsWeakSignature))
            {
                if (IsWeakSignature != null)
                {
                    writer.WritePropertyName("isWeakSignature"u8);
                    writer.WriteBooleanValue(IsWeakSignature.Value);
                }
                else
                {
                    writer.WriteNull("isWeakSignature");
                }
            }
            if (Optional.IsDefined(IsShortKeySize))
            {
                if (IsShortKeySize != null)
                {
                    writer.WritePropertyName("isShortKeySize"u8);
                    writer.WriteBooleanValue(IsShortKeySize.Value);
                }
                else
                {
                    writer.WriteNull("isShortKeySize");
                }
            }
            writer.WriteEndObject();
        }

        CryptoCertificateResult IJsonModel<CryptoCertificateResult>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CryptoCertificateResult>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CryptoCertificateResult)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeCryptoCertificateResult(document.RootElement, options);
        }

        internal static CryptoCertificateResult DeserializeCryptoCertificateResult(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            string cryptoCertId = default;
            string name0 = default;
            CryptoCertificateEntity subject = default;
            CryptoCertificateEntity issuer = default;
            DateTimeOffset? issuedDate = default;
            DateTimeOffset? expirationDate = default;
            string role = default;
            string signatureAlgorithm = default;
            long? keySize = default;
            string keyAlgorithm = default;
            string encoding = default;
            string serialNumber = default;
            string fingerprint = default;
            IList<string> usage = default;
            IReadOnlyList<string> filePaths = default;
            CryptoPairedKey pairedKey = default;
            bool? isExpired = default;
            bool? isSelfSigned = default;
            bool? isWeakSignature = default;
            bool? isShortKeySize = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("cryptoCertId"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                cryptoCertId = null;
                                continue;
                            }
                            cryptoCertId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("name"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                name0 = null;
                                continue;
                            }
                            name0 = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("subject"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                subject = null;
                                continue;
                            }
                            subject = CryptoCertificateEntity.DeserializeCryptoCertificateEntity(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("issuer"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                issuer = null;
                                continue;
                            }
                            issuer = CryptoCertificateEntity.DeserializeCryptoCertificateEntity(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("issuedDate"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                issuedDate = null;
                                continue;
                            }
                            issuedDate = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("expirationDate"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                expirationDate = null;
                                continue;
                            }
                            expirationDate = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("role"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                role = null;
                                continue;
                            }
                            role = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("signatureAlgorithm"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                signatureAlgorithm = null;
                                continue;
                            }
                            signatureAlgorithm = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("keySize"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                keySize = null;
                                continue;
                            }
                            keySize = property0.Value.GetInt64();
                            continue;
                        }
                        if (property0.NameEquals("keyAlgorithm"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                keyAlgorithm = null;
                                continue;
                            }
                            keyAlgorithm = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("encoding"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                encoding = null;
                                continue;
                            }
                            encoding = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("serialNumber"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                serialNumber = null;
                                continue;
                            }
                            serialNumber = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("fingerprint"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                fingerprint = null;
                                continue;
                            }
                            fingerprint = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("usage"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<string> array = new List<string>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(item.GetString());
                            }
                            usage = array;
                            continue;
                        }
                        if (property0.NameEquals("filePaths"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<string> array = new List<string>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(item.GetString());
                            }
                            filePaths = array;
                            continue;
                        }
                        if (property0.NameEquals("pairedKey"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                pairedKey = null;
                                continue;
                            }
                            pairedKey = CryptoPairedKey.DeserializeCryptoPairedKey(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("isExpired"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                isExpired = null;
                                continue;
                            }
                            isExpired = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("isSelfSigned"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                isSelfSigned = null;
                                continue;
                            }
                            isSelfSigned = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("isWeakSignature"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                isWeakSignature = null;
                                continue;
                            }
                            isWeakSignature = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("isShortKeySize"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                isShortKeySize = null;
                                continue;
                            }
                            isShortKeySize = property0.Value.GetBoolean();
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new CryptoCertificateResult(
                id,
                name,
                type,
                systemData,
                cryptoCertId,
                name0,
                subject,
                issuer,
                issuedDate,
                expirationDate,
                role,
                signatureAlgorithm,
                keySize,
                keyAlgorithm,
                encoding,
                serialNumber,
                fingerprint,
                usage ?? new ChangeTrackingList<string>(),
                filePaths ?? new ChangeTrackingList<string>(),
                pairedKey,
                isExpired,
                isSelfSigned,
                isWeakSignature,
                isShortKeySize,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<CryptoCertificateResult>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CryptoCertificateResult>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(CryptoCertificateResult)} does not support writing '{options.Format}' format.");
            }
        }

        CryptoCertificateResult IPersistableModel<CryptoCertificateResult>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CryptoCertificateResult>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeCryptoCertificateResult(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(CryptoCertificateResult)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<CryptoCertificateResult>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
