// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.IotFirmwareDefense.Models
{
    public partial class CryptoCertificateEntity : IUtf8JsonSerializable, IJsonModel<CryptoCertificateEntity>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<CryptoCertificateEntity>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<CryptoCertificateEntity>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CryptoCertificateEntity>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CryptoCertificateEntity)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(CommonName))
            {
                if (CommonName != null)
                {
                    writer.WritePropertyName("commonName"u8);
                    writer.WriteStringValue(CommonName);
                }
                else
                {
                    writer.WriteNull("commonName");
                }
            }
            if (Optional.IsDefined(Organization))
            {
                if (Organization != null)
                {
                    writer.WritePropertyName("organization"u8);
                    writer.WriteStringValue(Organization);
                }
                else
                {
                    writer.WriteNull("organization");
                }
            }
            if (Optional.IsDefined(OrganizationalUnit))
            {
                if (OrganizationalUnit != null)
                {
                    writer.WritePropertyName("organizationalUnit"u8);
                    writer.WriteStringValue(OrganizationalUnit);
                }
                else
                {
                    writer.WriteNull("organizationalUnit");
                }
            }
            if (Optional.IsDefined(State))
            {
                if (State != null)
                {
                    writer.WritePropertyName("state"u8);
                    writer.WriteStringValue(State);
                }
                else
                {
                    writer.WriteNull("state");
                }
            }
            if (Optional.IsDefined(Country))
            {
                if (Country != null)
                {
                    writer.WritePropertyName("country"u8);
                    writer.WriteStringValue(Country);
                }
                else
                {
                    writer.WriteNull("country");
                }
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        CryptoCertificateEntity IJsonModel<CryptoCertificateEntity>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CryptoCertificateEntity>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CryptoCertificateEntity)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeCryptoCertificateEntity(document.RootElement, options);
        }

        internal static CryptoCertificateEntity DeserializeCryptoCertificateEntity(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string commonName = default;
            string organization = default;
            string organizationalUnit = default;
            string state = default;
            string country = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("commonName"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        commonName = null;
                        continue;
                    }
                    commonName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("organization"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        organization = null;
                        continue;
                    }
                    organization = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("organizationalUnit"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        organizationalUnit = null;
                        continue;
                    }
                    organizationalUnit = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("state"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        state = null;
                        continue;
                    }
                    state = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("country"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        country = null;
                        continue;
                    }
                    country = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new CryptoCertificateEntity(
                commonName,
                organization,
                organizationalUnit,
                state,
                country,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<CryptoCertificateEntity>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CryptoCertificateEntity>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(CryptoCertificateEntity)} does not support writing '{options.Format}' format.");
            }
        }

        CryptoCertificateEntity IPersistableModel<CryptoCertificateEntity>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CryptoCertificateEntity>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeCryptoCertificateEntity(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(CryptoCertificateEntity)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<CryptoCertificateEntity>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
