// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.IotFirmwareDefense.Models
{
    /// <summary> binary hardening analysis result resource. </summary>
    public partial class BinaryHardeningResult : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BinaryHardeningResult"/>. </summary>
        public BinaryHardeningResult()
        {
        }

        /// <summary> Initializes a new instance of <see cref="BinaryHardeningResult"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="binaryHardeningId"> ID for the binary hardening result. </param>
        /// <param name="architecture"> The architecture of the uploaded firmware. </param>
        /// <param name="filePath"> The executable path. </param>
        /// <param name="class"> The executable class to indicate 32 or 64 bit. </param>
        /// <param name="runpath"> The runpath of the uploaded firmware. </param>
        /// <param name="rpath"> The rpath of the uploaded firmware. </param>
        /// <param name="nxFlag"> NX (no-execute) flag. </param>
        /// <param name="pieFlag"> PIE (position independent executable) flag. </param>
        /// <param name="relroFlag"> RELRO (relocation read-only) flag. </param>
        /// <param name="canaryFlag"> Canary (stack canaries) flag. </param>
        /// <param name="strippedFlag"> Stripped flag. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BinaryHardeningResult(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string binaryHardeningId, string architecture, string filePath, string @class, string runpath, string rpath, bool? nxFlag, bool? pieFlag, bool? relroFlag, bool? canaryFlag, bool? strippedFlag, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            BinaryHardeningId = binaryHardeningId;
            Architecture = architecture;
            FilePath = filePath;
            Class = @class;
            Runpath = runpath;
            Rpath = rpath;
            NXFlag = nxFlag;
            PieFlag = pieFlag;
            RelroFlag = relroFlag;
            CanaryFlag = canaryFlag;
            StrippedFlag = strippedFlag;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> ID for the binary hardening result. </summary>
        public string BinaryHardeningId { get; set; }
        /// <summary> The architecture of the uploaded firmware. </summary>
        public string Architecture { get; set; }
        /// <summary> The executable path. </summary>
        public string FilePath { get; set; }
        /// <summary> The executable class to indicate 32 or 64 bit. </summary>
        public string Class { get; set; }
        /// <summary> The runpath of the uploaded firmware. </summary>
        public string Runpath { get; set; }
        /// <summary> The rpath of the uploaded firmware. </summary>
        public string Rpath { get; set; }
        /// <summary> NX (no-execute) flag. </summary>
        public bool? NXFlag { get; set; }
        /// <summary> PIE (position independent executable) flag. </summary>
        public bool? PieFlag { get; set; }
        /// <summary> RELRO (relocation read-only) flag. </summary>
        public bool? RelroFlag { get; set; }
        /// <summary> Canary (stack canaries) flag. </summary>
        public bool? CanaryFlag { get; set; }
        /// <summary> Stripped flag. </summary>
        public bool? StrippedFlag { get; set; }
    }
}
