// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.IotFirmwareDefense.Models
{
    public partial class BinaryHardeningResult : IUtf8JsonSerializable, IJsonModel<BinaryHardeningResult>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<BinaryHardeningResult>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<BinaryHardeningResult>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BinaryHardeningResult>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BinaryHardeningResult)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(BinaryHardeningId))
            {
                if (BinaryHardeningId != null)
                {
                    writer.WritePropertyName("binaryHardeningId"u8);
                    writer.WriteStringValue(BinaryHardeningId);
                }
                else
                {
                    writer.WriteNull("binaryHardeningId");
                }
            }
            if (Optional.IsDefined(Architecture))
            {
                if (Architecture != null)
                {
                    writer.WritePropertyName("architecture"u8);
                    writer.WriteStringValue(Architecture);
                }
                else
                {
                    writer.WriteNull("architecture");
                }
            }
            if (Optional.IsDefined(FilePath))
            {
                if (FilePath != null)
                {
                    writer.WritePropertyName("filePath"u8);
                    writer.WriteStringValue(FilePath);
                }
                else
                {
                    writer.WriteNull("filePath");
                }
            }
            if (Optional.IsDefined(Class))
            {
                if (Class != null)
                {
                    writer.WritePropertyName("class"u8);
                    writer.WriteStringValue(Class);
                }
                else
                {
                    writer.WriteNull("class");
                }
            }
            if (Optional.IsDefined(Runpath))
            {
                if (Runpath != null)
                {
                    writer.WritePropertyName("runpath"u8);
                    writer.WriteStringValue(Runpath);
                }
                else
                {
                    writer.WriteNull("runpath");
                }
            }
            if (Optional.IsDefined(Rpath))
            {
                if (Rpath != null)
                {
                    writer.WritePropertyName("rpath"u8);
                    writer.WriteStringValue(Rpath);
                }
                else
                {
                    writer.WriteNull("rpath");
                }
            }
            writer.WritePropertyName("features"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(NXFlag))
            {
                writer.WritePropertyName("nx"u8);
                writer.WriteBooleanValue(NXFlag.Value);
            }
            if (Optional.IsDefined(PieFlag))
            {
                writer.WritePropertyName("pie"u8);
                writer.WriteBooleanValue(PieFlag.Value);
            }
            if (Optional.IsDefined(RelroFlag))
            {
                writer.WritePropertyName("relro"u8);
                writer.WriteBooleanValue(RelroFlag.Value);
            }
            if (Optional.IsDefined(CanaryFlag))
            {
                writer.WritePropertyName("canary"u8);
                writer.WriteBooleanValue(CanaryFlag.Value);
            }
            if (Optional.IsDefined(StrippedFlag))
            {
                writer.WritePropertyName("stripped"u8);
                writer.WriteBooleanValue(StrippedFlag.Value);
            }
            writer.WriteEndObject();
            writer.WriteEndObject();
        }

        BinaryHardeningResult IJsonModel<BinaryHardeningResult>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BinaryHardeningResult>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BinaryHardeningResult)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeBinaryHardeningResult(document.RootElement, options);
        }

        internal static BinaryHardeningResult DeserializeBinaryHardeningResult(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            string binaryHardeningId = default;
            string architecture = default;
            string filePath = default;
            string @class = default;
            string runpath = default;
            string rpath = default;
            bool? nx = default;
            bool? pie = default;
            bool? relro = default;
            bool? canary = default;
            bool? stripped = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("binaryHardeningId"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                binaryHardeningId = null;
                                continue;
                            }
                            binaryHardeningId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("architecture"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                architecture = null;
                                continue;
                            }
                            architecture = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("filePath"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                filePath = null;
                                continue;
                            }
                            filePath = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("class"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                @class = null;
                                continue;
                            }
                            @class = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("runpath"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                runpath = null;
                                continue;
                            }
                            runpath = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("rpath"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                rpath = null;
                                continue;
                            }
                            rpath = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("features"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                property0.ThrowNonNullablePropertyIsNull();
                                continue;
                            }
                            foreach (var property1 in property0.Value.EnumerateObject())
                            {
                                if (property1.NameEquals("nx"u8))
                                {
                                    if (property1.Value.ValueKind == JsonValueKind.Null)
                                    {
                                        continue;
                                    }
                                    nx = property1.Value.GetBoolean();
                                    continue;
                                }
                                if (property1.NameEquals("pie"u8))
                                {
                                    if (property1.Value.ValueKind == JsonValueKind.Null)
                                    {
                                        continue;
                                    }
                                    pie = property1.Value.GetBoolean();
                                    continue;
                                }
                                if (property1.NameEquals("relro"u8))
                                {
                                    if (property1.Value.ValueKind == JsonValueKind.Null)
                                    {
                                        continue;
                                    }
                                    relro = property1.Value.GetBoolean();
                                    continue;
                                }
                                if (property1.NameEquals("canary"u8))
                                {
                                    if (property1.Value.ValueKind == JsonValueKind.Null)
                                    {
                                        continue;
                                    }
                                    canary = property1.Value.GetBoolean();
                                    continue;
                                }
                                if (property1.NameEquals("stripped"u8))
                                {
                                    if (property1.Value.ValueKind == JsonValueKind.Null)
                                    {
                                        continue;
                                    }
                                    stripped = property1.Value.GetBoolean();
                                    continue;
                                }
                            }
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new BinaryHardeningResult(
                id,
                name,
                type,
                systemData,
                binaryHardeningId,
                architecture,
                filePath,
                @class,
                runpath,
                rpath,
                nx,
                pie,
                relro,
                canary,
                stripped,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<BinaryHardeningResult>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BinaryHardeningResult>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(BinaryHardeningResult)} does not support writing '{options.Format}' format.");
            }
        }

        BinaryHardeningResult IPersistableModel<BinaryHardeningResult>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BinaryHardeningResult>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeBinaryHardeningResult(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(BinaryHardeningResult)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<BinaryHardeningResult>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
