// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.IotFirmwareDefense.Models;

namespace Azure.ResourceManager.IotFirmwareDefense
{
    /// <summary>
    /// A Class representing an IotFirmware along with the instance operations that can be performed on it.
    /// If you have a <see cref="ResourceIdentifier"/> you can construct an <see cref="IotFirmwareResource"/>
    /// from an instance of <see cref="ArmClient"/> using the GetIotFirmwareResource method.
    /// Otherwise you can get one from its parent resource <see cref="FirmwareAnalysisWorkspaceResource"/> using the GetIotFirmware method.
    /// </summary>
    public partial class IotFirmwareResource : ArmResource
    {
        /// <summary> Generate the resource identifier of a <see cref="IotFirmwareResource"/> instance. </summary>
        /// <param name="subscriptionId"> The subscriptionId. </param>
        /// <param name="resourceGroupName"> The resourceGroupName. </param>
        /// <param name="workspaceName"> The workspaceName. </param>
        /// <param name="firmwareId"> The firmwareId. </param>
        public static ResourceIdentifier CreateResourceIdentifier(string subscriptionId, string resourceGroupName, string workspaceName, string firmwareId)
        {
            var resourceId = $"/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTFirmwareDefense/workspaces/{workspaceName}/firmwares/{firmwareId}";
            return new ResourceIdentifier(resourceId);
        }

        private readonly ClientDiagnostics _iotFirmwareFirmwaresClientDiagnostics;
        private readonly FirmwaresRestOperations _iotFirmwareFirmwaresRestClient;
        private readonly ClientDiagnostics _binaryHardeningClientDiagnostics;
        private readonly BinaryHardeningRestOperations _binaryHardeningRestClient;
        private readonly ClientDiagnostics _cryptoCertificatesClientDiagnostics;
        private readonly CryptoCertificatesRestOperations _cryptoCertificatesRestClient;
        private readonly ClientDiagnostics _cryptoKeysClientDiagnostics;
        private readonly CryptoKeysRestOperations _cryptoKeysRestClient;
        private readonly ClientDiagnostics _cvesClientDiagnostics;
        private readonly CvesRestOperations _cvesRestClient;
        private readonly ClientDiagnostics _passwordHashesClientDiagnostics;
        private readonly PasswordHashesRestOperations _passwordHashesRestClient;
        private readonly ClientDiagnostics _sbomComponentsClientDiagnostics;
        private readonly SbomComponentsRestOperations _sbomComponentsRestClient;
        private readonly IotFirmwareData _data;

        /// <summary> Gets the resource type for the operations. </summary>
        public static readonly ResourceType ResourceType = "Microsoft.IoTFirmwareDefense/workspaces/firmwares";

        /// <summary> Initializes a new instance of the <see cref="IotFirmwareResource"/> class for mocking. </summary>
        protected IotFirmwareResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="IotFirmwareResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="data"> The resource that is the target of operations. </param>
        internal IotFirmwareResource(ArmClient client, IotFirmwareData data) : this(client, data.Id)
        {
            HasData = true;
            _data = data;
        }

        /// <summary> Initializes a new instance of the <see cref="IotFirmwareResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal IotFirmwareResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _iotFirmwareFirmwaresClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.IotFirmwareDefense", ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ResourceType, out string iotFirmwareFirmwaresApiVersion);
            _iotFirmwareFirmwaresRestClient = new FirmwaresRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, iotFirmwareFirmwaresApiVersion);
            _binaryHardeningClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.IotFirmwareDefense", ProviderConstants.DefaultProviderNamespace, Diagnostics);
            _binaryHardeningRestClient = new BinaryHardeningRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint);
            _cryptoCertificatesClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.IotFirmwareDefense", ProviderConstants.DefaultProviderNamespace, Diagnostics);
            _cryptoCertificatesRestClient = new CryptoCertificatesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint);
            _cryptoKeysClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.IotFirmwareDefense", ProviderConstants.DefaultProviderNamespace, Diagnostics);
            _cryptoKeysRestClient = new CryptoKeysRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint);
            _cvesClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.IotFirmwareDefense", ProviderConstants.DefaultProviderNamespace, Diagnostics);
            _cvesRestClient = new CvesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint);
            _passwordHashesClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.IotFirmwareDefense", ProviderConstants.DefaultProviderNamespace, Diagnostics);
            _passwordHashesRestClient = new PasswordHashesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint);
            _sbomComponentsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.IotFirmwareDefense", ProviderConstants.DefaultProviderNamespace, Diagnostics);
            _sbomComponentsRestClient = new SbomComponentsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        /// <summary> Gets whether or not the current instance has data. </summary>
        public virtual bool HasData { get; }

        /// <summary> Gets the data representing this Feature. </summary>
        /// <exception cref="InvalidOperationException"> Throws if there is no data loaded in the current instance. </exception>
        public virtual IotFirmwareData Data
        {
            get
            {
                if (!HasData)
                    throw new InvalidOperationException("The current instance does not have data, you must call Get first.");
                return _data;
            }
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceType), nameof(id));
        }

        /// <summary> Gets a collection of FirmwareAnalysisSummaryResources in the IotFirmware. </summary>
        /// <returns> An object representing collection of FirmwareAnalysisSummaryResources and their operations over a FirmwareAnalysisSummaryResource. </returns>
        public virtual FirmwareAnalysisSummaryCollection GetFirmwareAnalysisSummaries()
        {
            return GetCachedClient(client => new FirmwareAnalysisSummaryCollection(client, Id));
        }

        /// <summary>
        /// Get an analysis result summary of a firmware by name.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTFirmwareDefense/workspaces/{workspaceName}/firmwares/{firmwareId}/summaries/{summaryName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Summaries_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-10</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="FirmwareAnalysisSummaryResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="summaryName"> The Firmware analysis summary name describing the type of summary. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        [ForwardsClientCalls]
        public virtual async Task<Response<FirmwareAnalysisSummaryResource>> GetFirmwareAnalysisSummaryAsync(FirmwareAnalysisSummaryName summaryName, CancellationToken cancellationToken = default)
        {
            return await GetFirmwareAnalysisSummaries().GetAsync(summaryName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Get an analysis result summary of a firmware by name.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTFirmwareDefense/workspaces/{workspaceName}/firmwares/{firmwareId}/summaries/{summaryName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Summaries_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-10</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="FirmwareAnalysisSummaryResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="summaryName"> The Firmware analysis summary name describing the type of summary. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        [ForwardsClientCalls]
        public virtual Response<FirmwareAnalysisSummaryResource> GetFirmwareAnalysisSummary(FirmwareAnalysisSummaryName summaryName, CancellationToken cancellationToken = default)
        {
            return GetFirmwareAnalysisSummaries().Get(summaryName, cancellationToken);
        }

        /// <summary>
        /// Get firmware.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTFirmwareDefense/workspaces/{workspaceName}/firmwares/{firmwareId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Firmwares_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-10</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="IotFirmwareResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<IotFirmwareResource>> GetAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _iotFirmwareFirmwaresClientDiagnostics.CreateScope("IotFirmwareResource.Get");
            scope.Start();
            try
            {
                var response = await _iotFirmwareFirmwaresRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new IotFirmwareResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get firmware.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTFirmwareDefense/workspaces/{workspaceName}/firmwares/{firmwareId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Firmwares_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-10</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="IotFirmwareResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<IotFirmwareResource> Get(CancellationToken cancellationToken = default)
        {
            using var scope = _iotFirmwareFirmwaresClientDiagnostics.CreateScope("IotFirmwareResource.Get");
            scope.Start();
            try
            {
                var response = _iotFirmwareFirmwaresRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new IotFirmwareResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// The operation to delete a firmware.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTFirmwareDefense/workspaces/{workspaceName}/firmwares/{firmwareId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Firmwares_Delete</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-10</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="IotFirmwareResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<ArmOperation> DeleteAsync(WaitUntil waitUntil, CancellationToken cancellationToken = default)
        {
            using var scope = _iotFirmwareFirmwaresClientDiagnostics.CreateScope("IotFirmwareResource.Delete");
            scope.Start();
            try
            {
                var response = await _iotFirmwareFirmwaresRestClient.DeleteAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, cancellationToken).ConfigureAwait(false);
                var uri = _iotFirmwareFirmwaresRestClient.CreateDeleteRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Delete, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new IotFirmwareDefenseArmOperation(response, rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionResponseAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// The operation to delete a firmware.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTFirmwareDefense/workspaces/{workspaceName}/firmwares/{firmwareId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Firmwares_Delete</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-10</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="IotFirmwareResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual ArmOperation Delete(WaitUntil waitUntil, CancellationToken cancellationToken = default)
        {
            using var scope = _iotFirmwareFirmwaresClientDiagnostics.CreateScope("IotFirmwareResource.Delete");
            scope.Start();
            try
            {
                var response = _iotFirmwareFirmwaresRestClient.Delete(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, cancellationToken);
                var uri = _iotFirmwareFirmwaresRestClient.CreateDeleteRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Delete, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new IotFirmwareDefenseArmOperation(response, rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletionResponse(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// The operation to update firmware.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTFirmwareDefense/workspaces/{workspaceName}/firmwares/{firmwareId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Firmwares_Update</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-10</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="IotFirmwareResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="patch"> Details of the firmware being created or updated. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="patch"/> is null. </exception>
        public virtual async Task<Response<IotFirmwareResource>> UpdateAsync(IotFirmwarePatch patch, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(patch, nameof(patch));

            using var scope = _iotFirmwareFirmwaresClientDiagnostics.CreateScope("IotFirmwareResource.Update");
            scope.Start();
            try
            {
                var response = await _iotFirmwareFirmwaresRestClient.UpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, patch, cancellationToken).ConfigureAwait(false);
                return Response.FromValue(new IotFirmwareResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// The operation to update firmware.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTFirmwareDefense/workspaces/{workspaceName}/firmwares/{firmwareId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Firmwares_Update</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-10</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="IotFirmwareResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="patch"> Details of the firmware being created or updated. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="patch"/> is null. </exception>
        public virtual Response<IotFirmwareResource> Update(IotFirmwarePatch patch, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(patch, nameof(patch));

            using var scope = _iotFirmwareFirmwaresClientDiagnostics.CreateScope("IotFirmwareResource.Update");
            scope.Start();
            try
            {
                var response = _iotFirmwareFirmwaresRestClient.Update(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, patch, cancellationToken);
                return Response.FromValue(new IotFirmwareResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Lists binary hardening analysis results of a firmware.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTFirmwareDefense/workspaces/{workspaceName}/firmwares/{firmwareId}/binaryHardeningResults</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BinaryHardening_ListByFirmware</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-10</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="BinaryHardeningResult"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<BinaryHardeningResult> GetBinaryHardeningResultsAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _binaryHardeningRestClient.CreateListByFirmwareRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _binaryHardeningRestClient.CreateListByFirmwareNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => BinaryHardeningResult.DeserializeBinaryHardeningResult(e), _binaryHardeningClientDiagnostics, Pipeline, "IotFirmwareResource.GetBinaryHardeningResults", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists binary hardening analysis results of a firmware.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTFirmwareDefense/workspaces/{workspaceName}/firmwares/{firmwareId}/binaryHardeningResults</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BinaryHardening_ListByFirmware</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-10</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="BinaryHardeningResult"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<BinaryHardeningResult> GetBinaryHardeningResults(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _binaryHardeningRestClient.CreateListByFirmwareRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _binaryHardeningRestClient.CreateListByFirmwareNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => BinaryHardeningResult.DeserializeBinaryHardeningResult(e), _binaryHardeningClientDiagnostics, Pipeline, "IotFirmwareResource.GetBinaryHardeningResults", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists cryptographic certificate analysis results found in a firmware.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTFirmwareDefense/workspaces/{workspaceName}/firmwares/{firmwareId}/cryptoCertificates</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>CryptoCertificates_ListByFirmware</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-10</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="CryptoCertificateResult"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<CryptoCertificateResult> GetCryptoCertificatesAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _cryptoCertificatesRestClient.CreateListByFirmwareRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _cryptoCertificatesRestClient.CreateListByFirmwareNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => CryptoCertificateResult.DeserializeCryptoCertificateResult(e), _cryptoCertificatesClientDiagnostics, Pipeline, "IotFirmwareResource.GetCryptoCertificates", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists cryptographic certificate analysis results found in a firmware.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTFirmwareDefense/workspaces/{workspaceName}/firmwares/{firmwareId}/cryptoCertificates</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>CryptoCertificates_ListByFirmware</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-10</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="CryptoCertificateResult"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<CryptoCertificateResult> GetCryptoCertificates(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _cryptoCertificatesRestClient.CreateListByFirmwareRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _cryptoCertificatesRestClient.CreateListByFirmwareNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => CryptoCertificateResult.DeserializeCryptoCertificateResult(e), _cryptoCertificatesClientDiagnostics, Pipeline, "IotFirmwareResource.GetCryptoCertificates", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists cryptographic key analysis results found in a firmware.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTFirmwareDefense/workspaces/{workspaceName}/firmwares/{firmwareId}/cryptoKeys</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>CryptoKeys_ListByFirmware</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-10</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="CryptoKeyResult"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<CryptoKeyResult> GetCryptoKeysAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _cryptoKeysRestClient.CreateListByFirmwareRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _cryptoKeysRestClient.CreateListByFirmwareNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => CryptoKeyResult.DeserializeCryptoKeyResult(e), _cryptoKeysClientDiagnostics, Pipeline, "IotFirmwareResource.GetCryptoKeys", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists cryptographic key analysis results found in a firmware.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTFirmwareDefense/workspaces/{workspaceName}/firmwares/{firmwareId}/cryptoKeys</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>CryptoKeys_ListByFirmware</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-10</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="CryptoKeyResult"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<CryptoKeyResult> GetCryptoKeys(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _cryptoKeysRestClient.CreateListByFirmwareRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _cryptoKeysRestClient.CreateListByFirmwareNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => CryptoKeyResult.DeserializeCryptoKeyResult(e), _cryptoKeysClientDiagnostics, Pipeline, "IotFirmwareResource.GetCryptoKeys", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists CVE analysis results of a firmware.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTFirmwareDefense/workspaces/{workspaceName}/firmwares/{firmwareId}/cves</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Cves_ListByFirmware</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-10</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="CveResult"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<CveResult> GetCvesAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _cvesRestClient.CreateListByFirmwareRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _cvesRestClient.CreateListByFirmwareNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => CveResult.DeserializeCveResult(e), _cvesClientDiagnostics, Pipeline, "IotFirmwareResource.GetCves", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists CVE analysis results of a firmware.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTFirmwareDefense/workspaces/{workspaceName}/firmwares/{firmwareId}/cves</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Cves_ListByFirmware</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-10</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="CveResult"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<CveResult> GetCves(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _cvesRestClient.CreateListByFirmwareRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _cvesRestClient.CreateListByFirmwareNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => CveResult.DeserializeCveResult(e), _cvesClientDiagnostics, Pipeline, "IotFirmwareResource.GetCves", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// The operation to a url for file download.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTFirmwareDefense/workspaces/{workspaceName}/firmwares/{firmwareId}/generateDownloadUrl</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Firmwares_GenerateDownloadUri</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-10</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="IotFirmwareResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<FirmwareUriToken>> GenerateDownloadUriAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _iotFirmwareFirmwaresClientDiagnostics.CreateScope("IotFirmwareResource.GenerateDownloadUri");
            scope.Start();
            try
            {
                var response = await _iotFirmwareFirmwaresRestClient.GenerateDownloadUriAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// The operation to a url for file download.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTFirmwareDefense/workspaces/{workspaceName}/firmwares/{firmwareId}/generateDownloadUrl</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Firmwares_GenerateDownloadUri</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-10</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="IotFirmwareResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<FirmwareUriToken> GenerateDownloadUri(CancellationToken cancellationToken = default)
        {
            using var scope = _iotFirmwareFirmwaresClientDiagnostics.CreateScope("IotFirmwareResource.GenerateDownloadUri");
            scope.Start();
            try
            {
                var response = _iotFirmwareFirmwaresRestClient.GenerateDownloadUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// The operation to a url for tar file download.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTFirmwareDefense/workspaces/{workspaceName}/firmwares/{firmwareId}/generateFilesystemDownloadUrl</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Firmwares_GenerateFilesystemDownloadUri</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-10</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="IotFirmwareResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<FirmwareUriToken>> GenerateFilesystemDownloadUriAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _iotFirmwareFirmwaresClientDiagnostics.CreateScope("IotFirmwareResource.GenerateFilesystemDownloadUri");
            scope.Start();
            try
            {
                var response = await _iotFirmwareFirmwaresRestClient.GenerateFilesystemDownloadUriAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// The operation to a url for tar file download.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTFirmwareDefense/workspaces/{workspaceName}/firmwares/{firmwareId}/generateFilesystemDownloadUrl</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Firmwares_GenerateFilesystemDownloadUri</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-10</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="IotFirmwareResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<FirmwareUriToken> GenerateFilesystemDownloadUri(CancellationToken cancellationToken = default)
        {
            using var scope = _iotFirmwareFirmwaresClientDiagnostics.CreateScope("IotFirmwareResource.GenerateFilesystemDownloadUri");
            scope.Start();
            try
            {
                var response = _iotFirmwareFirmwaresRestClient.GenerateFilesystemDownloadUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Lists password hash analysis results of a firmware.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTFirmwareDefense/workspaces/{workspaceName}/firmwares/{firmwareId}/passwordHashes</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>PasswordHashes_ListByFirmware</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-10</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="PasswordHashResult"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<PasswordHashResult> GetPasswordHashesAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _passwordHashesRestClient.CreateListByFirmwareRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _passwordHashesRestClient.CreateListByFirmwareNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => PasswordHashResult.DeserializePasswordHashResult(e), _passwordHashesClientDiagnostics, Pipeline, "IotFirmwareResource.GetPasswordHashes", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists password hash analysis results of a firmware.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTFirmwareDefense/workspaces/{workspaceName}/firmwares/{firmwareId}/passwordHashes</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>PasswordHashes_ListByFirmware</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-10</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="PasswordHashResult"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<PasswordHashResult> GetPasswordHashes(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _passwordHashesRestClient.CreateListByFirmwareRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _passwordHashesRestClient.CreateListByFirmwareNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => PasswordHashResult.DeserializePasswordHashResult(e), _passwordHashesClientDiagnostics, Pipeline, "IotFirmwareResource.GetPasswordHashes", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists SBOM analysis results of a firmware.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTFirmwareDefense/workspaces/{workspaceName}/firmwares/{firmwareId}/sbomComponents</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SbomComponents_ListByFirmware</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-10</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="SbomComponentResult"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<SbomComponentResult> GetSbomComponentsAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _sbomComponentsRestClient.CreateListByFirmwareRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _sbomComponentsRestClient.CreateListByFirmwareNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => SbomComponentResult.DeserializeSbomComponentResult(e), _sbomComponentsClientDiagnostics, Pipeline, "IotFirmwareResource.GetSbomComponents", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists SBOM analysis results of a firmware.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTFirmwareDefense/workspaces/{workspaceName}/firmwares/{firmwareId}/sbomComponents</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SbomComponents_ListByFirmware</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-10</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="SbomComponentResult"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<SbomComponentResult> GetSbomComponents(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _sbomComponentsRestClient.CreateListByFirmwareRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _sbomComponentsRestClient.CreateListByFirmwareNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => SbomComponentResult.DeserializeSbomComponentResult(e), _sbomComponentsClientDiagnostics, Pipeline, "IotFirmwareResource.GetSbomComponents", "value", "nextLink", cancellationToken);
        }
    }
}
