// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.IotFirmwareDefense.Models;

namespace Azure.ResourceManager.IotFirmwareDefense
{
    /// <summary>
    /// A Class representing a FirmwareAnalysisSummary along with the instance operations that can be performed on it.
    /// If you have a <see cref="ResourceIdentifier"/> you can construct a <see cref="FirmwareAnalysisSummaryResource"/>
    /// from an instance of <see cref="ArmClient"/> using the GetFirmwareAnalysisSummaryResource method.
    /// Otherwise you can get one from its parent resource <see cref="IotFirmwareResource"/> using the GetFirmwareAnalysisSummary method.
    /// </summary>
    public partial class FirmwareAnalysisSummaryResource : ArmResource
    {
        /// <summary> Generate the resource identifier of a <see cref="FirmwareAnalysisSummaryResource"/> instance. </summary>
        /// <param name="subscriptionId"> The subscriptionId. </param>
        /// <param name="resourceGroupName"> The resourceGroupName. </param>
        /// <param name="workspaceName"> The workspaceName. </param>
        /// <param name="firmwareId"> The firmwareId. </param>
        /// <param name="summaryName"> The summaryName. </param>
        public static ResourceIdentifier CreateResourceIdentifier(string subscriptionId, string resourceGroupName, string workspaceName, string firmwareId, FirmwareAnalysisSummaryName summaryName)
        {
            var resourceId = $"/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTFirmwareDefense/workspaces/{workspaceName}/firmwares/{firmwareId}/summaries/{summaryName}";
            return new ResourceIdentifier(resourceId);
        }

        private readonly ClientDiagnostics _firmwareAnalysisSummarySummariesClientDiagnostics;
        private readonly SummariesRestOperations _firmwareAnalysisSummarySummariesRestClient;
        private readonly FirmwareAnalysisSummaryData _data;

        /// <summary> Gets the resource type for the operations. </summary>
        public static readonly ResourceType ResourceType = "Microsoft.IoTFirmwareDefense/workspaces/firmwares/summaries";

        /// <summary> Initializes a new instance of the <see cref="FirmwareAnalysisSummaryResource"/> class for mocking. </summary>
        protected FirmwareAnalysisSummaryResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="FirmwareAnalysisSummaryResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="data"> The resource that is the target of operations. </param>
        internal FirmwareAnalysisSummaryResource(ArmClient client, FirmwareAnalysisSummaryData data) : this(client, data.Id)
        {
            HasData = true;
            _data = data;
        }

        /// <summary> Initializes a new instance of the <see cref="FirmwareAnalysisSummaryResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal FirmwareAnalysisSummaryResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _firmwareAnalysisSummarySummariesClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.IotFirmwareDefense", ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ResourceType, out string firmwareAnalysisSummarySummariesApiVersion);
            _firmwareAnalysisSummarySummariesRestClient = new SummariesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, firmwareAnalysisSummarySummariesApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        /// <summary> Gets whether or not the current instance has data. </summary>
        public virtual bool HasData { get; }

        /// <summary> Gets the data representing this Feature. </summary>
        /// <exception cref="InvalidOperationException"> Throws if there is no data loaded in the current instance. </exception>
        public virtual FirmwareAnalysisSummaryData Data
        {
            get
            {
                if (!HasData)
                    throw new InvalidOperationException("The current instance does not have data, you must call Get first.");
                return _data;
            }
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceType), nameof(id));
        }

        /// <summary>
        /// Get an analysis result summary of a firmware by name.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTFirmwareDefense/workspaces/{workspaceName}/firmwares/{firmwareId}/summaries/{summaryName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Summaries_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-10</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="FirmwareAnalysisSummaryResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<FirmwareAnalysisSummaryResource>> GetAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _firmwareAnalysisSummarySummariesClientDiagnostics.CreateScope("FirmwareAnalysisSummaryResource.Get");
            scope.Start();
            try
            {
                var response = await _firmwareAnalysisSummarySummariesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new FirmwareAnalysisSummaryResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get an analysis result summary of a firmware by name.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTFirmwareDefense/workspaces/{workspaceName}/firmwares/{firmwareId}/summaries/{summaryName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Summaries_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-10</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="FirmwareAnalysisSummaryResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<FirmwareAnalysisSummaryResource> Get(CancellationToken cancellationToken = default)
        {
            using var scope = _firmwareAnalysisSummarySummariesClientDiagnostics.CreateScope("FirmwareAnalysisSummaryResource.Get");
            scope.Start();
            try
            {
                var response = _firmwareAnalysisSummarySummariesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new FirmwareAnalysisSummaryResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
