// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Threading;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.IotFirmwareDefense.Mocking
{
    /// <summary> A class to add extension methods to SubscriptionResource. </summary>
    public partial class MockableIotFirmwareDefenseSubscriptionResource : ArmResource
    {
        private ClientDiagnostics _firmwareAnalysisWorkspaceWorkspacesClientDiagnostics;
        private WorkspacesRestOperations _firmwareAnalysisWorkspaceWorkspacesRestClient;

        /// <summary> Initializes a new instance of the <see cref="MockableIotFirmwareDefenseSubscriptionResource"/> class for mocking. </summary>
        protected MockableIotFirmwareDefenseSubscriptionResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableIotFirmwareDefenseSubscriptionResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableIotFirmwareDefenseSubscriptionResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        private ClientDiagnostics FirmwareAnalysisWorkspaceWorkspacesClientDiagnostics => _firmwareAnalysisWorkspaceWorkspacesClientDiagnostics ??= new ClientDiagnostics("Azure.ResourceManager.IotFirmwareDefense", FirmwareAnalysisWorkspaceResource.ResourceType.Namespace, Diagnostics);
        private WorkspacesRestOperations FirmwareAnalysisWorkspaceWorkspacesRestClient => _firmwareAnalysisWorkspaceWorkspacesRestClient ??= new WorkspacesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, GetApiVersionOrNull(FirmwareAnalysisWorkspaceResource.ResourceType));

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Lists all of the firmware analysis workspaces in the specified subscription.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.IoTFirmwareDefense/workspaces</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Workspaces_ListBySubscription</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-10</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="FirmwareAnalysisWorkspaceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="FirmwareAnalysisWorkspaceResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<FirmwareAnalysisWorkspaceResource> GetFirmwareAnalysisWorkspacesAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => FirmwareAnalysisWorkspaceWorkspacesRestClient.CreateListBySubscriptionRequest(Id.SubscriptionId);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => FirmwareAnalysisWorkspaceWorkspacesRestClient.CreateListBySubscriptionNextPageRequest(nextLink, Id.SubscriptionId);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new FirmwareAnalysisWorkspaceResource(Client, FirmwareAnalysisWorkspaceData.DeserializeFirmwareAnalysisWorkspaceData(e)), FirmwareAnalysisWorkspaceWorkspacesClientDiagnostics, Pipeline, "MockableIotFirmwareDefenseSubscriptionResource.GetFirmwareAnalysisWorkspaces", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists all of the firmware analysis workspaces in the specified subscription.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.IoTFirmwareDefense/workspaces</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Workspaces_ListBySubscription</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-10</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="FirmwareAnalysisWorkspaceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="FirmwareAnalysisWorkspaceResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<FirmwareAnalysisWorkspaceResource> GetFirmwareAnalysisWorkspaces(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => FirmwareAnalysisWorkspaceWorkspacesRestClient.CreateListBySubscriptionRequest(Id.SubscriptionId);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => FirmwareAnalysisWorkspaceWorkspacesRestClient.CreateListBySubscriptionNextPageRequest(nextLink, Id.SubscriptionId);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new FirmwareAnalysisWorkspaceResource(Client, FirmwareAnalysisWorkspaceData.DeserializeFirmwareAnalysisWorkspaceData(e)), FirmwareAnalysisWorkspaceWorkspacesClientDiagnostics, Pipeline, "MockableIotFirmwareDefenseSubscriptionResource.GetFirmwareAnalysisWorkspaces", "value", "nextLink", cancellationToken);
        }
    }
}
