// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.IotFirmwareDefense.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmIotFirmwareDefenseModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="Models.BinaryHardeningResult"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="binaryHardeningId"> ID for the binary hardening result. </param>
        /// <param name="architecture"> The architecture of the uploaded firmware. </param>
        /// <param name="filePath"> The executable path. </param>
        /// <param name="class"> The executable class to indicate 32 or 64 bit. </param>
        /// <param name="runpath"> The runpath of the uploaded firmware. </param>
        /// <param name="rpath"> The rpath of the uploaded firmware. </param>
        /// <param name="nxFlag"> NX (no-execute) flag. </param>
        /// <param name="pieFlag"> PIE (position independent executable) flag. </param>
        /// <param name="relroFlag"> RELRO (relocation read-only) flag. </param>
        /// <param name="canaryFlag"> Canary (stack canaries) flag. </param>
        /// <param name="strippedFlag"> Stripped flag. </param>
        /// <returns> A new <see cref="Models.BinaryHardeningResult"/> instance for mocking. </returns>
        public static BinaryHardeningResult BinaryHardeningResult(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string binaryHardeningId = null, string architecture = null, string filePath = null, string @class = null, string runpath = null, string rpath = null, bool? nxFlag = null, bool? pieFlag = null, bool? relroFlag = null, bool? canaryFlag = null, bool? strippedFlag = null)
        {
            return new BinaryHardeningResult(
                id,
                name,
                resourceType,
                systemData,
                binaryHardeningId,
                architecture,
                filePath,
                @class,
                runpath,
                rpath,
                nxFlag,
                pieFlag,
                relroFlag,
                canaryFlag,
                strippedFlag,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CryptoCertificateResult"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="cryptoCertId"> ID for the certificate result. </param>
        /// <param name="namePropertiesName"> Name of the certificate. </param>
        /// <param name="subject"> Subject information of the certificate. </param>
        /// <param name="issuer"> Issuer information of the certificate. </param>
        /// <param name="issuedOn"> Issue date for the certificate. </param>
        /// <param name="expireOn"> Expiration date for the certificate. </param>
        /// <param name="role"> Role of the certificate (Root CA, etc). </param>
        /// <param name="signatureAlgorithm"> The signature algorithm used in the certificate. </param>
        /// <param name="keySize"> Size of the certificate's key in bits. </param>
        /// <param name="keyAlgorithm"> Key algorithm used in the certificate. </param>
        /// <param name="encoding"> Encoding used for the certificate. </param>
        /// <param name="serialNumber"> Serial number of the certificate. </param>
        /// <param name="fingerprint"> Fingerprint of the certificate. </param>
        /// <param name="usage"> List of functions the certificate can fulfill. </param>
        /// <param name="filePaths"> List of files where this certificate was found. </param>
        /// <param name="pairedKey"> A matching paired private key. </param>
        /// <param name="isExpired"> Indicates if the certificate is expired. </param>
        /// <param name="isSelfSigned"> Indicates if the certificate is self-signed. </param>
        /// <param name="isWeakSignature"> Indicates the signature algorithm used is insecure. </param>
        /// <param name="isShortKeySize"> Indicates the certificate's key size is considered too small to be secure for the key algorithm. </param>
        /// <returns> A new <see cref="Models.CryptoCertificateResult"/> instance for mocking. </returns>
        public static CryptoCertificateResult CryptoCertificateResult(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string cryptoCertId = null, string namePropertiesName = null, CryptoCertificateEntity subject = null, CryptoCertificateEntity issuer = null, DateTimeOffset? issuedOn = null, DateTimeOffset? expireOn = null, string role = null, string signatureAlgorithm = null, long? keySize = null, string keyAlgorithm = null, string encoding = null, string serialNumber = null, string fingerprint = null, IEnumerable<string> usage = null, IEnumerable<string> filePaths = null, CryptoPairedKey pairedKey = null, bool? isExpired = null, bool? isSelfSigned = null, bool? isWeakSignature = null, bool? isShortKeySize = null)
        {
            usage ??= new List<string>();
            filePaths ??= new List<string>();

            return new CryptoCertificateResult(
                id,
                name,
                resourceType,
                systemData,
                cryptoCertId,
                namePropertiesName,
                subject,
                issuer,
                issuedOn,
                expireOn,
                role,
                signatureAlgorithm,
                keySize,
                keyAlgorithm,
                encoding,
                serialNumber,
                fingerprint,
                usage?.ToList(),
                filePaths?.ToList(),
                pairedKey,
                isExpired,
                isSelfSigned,
                isWeakSignature,
                isShortKeySize,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CryptoKeyResult"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="cryptoKeyId"> ID for the key result. </param>
        /// <param name="keyType"> Type of the key (public or private). </param>
        /// <param name="keySize"> Size of the key in bits. </param>
        /// <param name="keyAlgorithm"> Key algorithm name. </param>
        /// <param name="usage"> Functions the key can fulfill. </param>
        /// <param name="filePaths"> List of files where this key was found. </param>
        /// <param name="pairedKey"> A matching paired key or certificate. </param>
        /// <param name="isShortKeySize"> Indicates the key size is considered too small to be secure for the algorithm. </param>
        /// <returns> A new <see cref="Models.CryptoKeyResult"/> instance for mocking. </returns>
        public static CryptoKeyResult CryptoKeyResult(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string cryptoKeyId = null, string keyType = null, long? keySize = null, string keyAlgorithm = null, IEnumerable<string> usage = null, IEnumerable<string> filePaths = null, CryptoPairedKey pairedKey = null, bool? isShortKeySize = null)
        {
            usage ??= new List<string>();
            filePaths ??= new List<string>();

            return new CryptoKeyResult(
                id,
                name,
                resourceType,
                systemData,
                cryptoKeyId,
                keyType,
                keySize,
                keyAlgorithm,
                usage?.ToList(),
                filePaths?.ToList(),
                pairedKey,
                isShortKeySize,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CveResult"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="cveId"> ID of the CVE result. </param>
        /// <param name="component"> The SBOM component for the CVE. </param>
        /// <param name="severity"> Severity of the CVE. </param>
        /// <param name="namePropertiesName"> Name of the CVE. </param>
        /// <param name="cvssScore"> A single CVSS score to represent the CVE. If a V3 score is specified, then it will use the V3 score. Otherwise if the V2 score is specified it will be the V2 score. </param>
        /// <param name="cvssVersion"> CVSS version of the CVE. </param>
        /// <param name="cvssV2Score"> CVSS V2 score of the CVE. </param>
        /// <param name="cvssV3Score"> CVSS V3 score of the CVE. </param>
        /// <param name="links"> The list of reference links for the CVE. </param>
        /// <param name="description"> The CVE description. </param>
        /// <returns> A new <see cref="Models.CveResult"/> instance for mocking. </returns>
        public static CveResult CveResult(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string cveId = null, CveComponent component = null, string severity = null, string namePropertiesName = null, string cvssScore = null, string cvssVersion = null, string cvssV2Score = null, string cvssV3Score = null, IEnumerable<CveLink> links = null, string description = null)
        {
            links ??= new List<CveLink>();

            return new CveResult(
                id,
                name,
                resourceType,
                systemData,
                cveId,
                component,
                severity,
                namePropertiesName,
                cvssScore,
                cvssVersion,
                cvssV2Score,
                cvssV3Score,
                links?.ToList(),
                description,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CveLink"/>. </summary>
        /// <param name="href"> The destination of the reference link. </param>
        /// <param name="label"> The label of the reference link. </param>
        /// <returns> A new <see cref="Models.CveLink"/> instance for mocking. </returns>
        public static CveLink CveLink(Uri href = null, string label = null)
        {
            return new CveLink(href, label, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="IotFirmwareDefense.IotFirmwareData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="fileName"> File name for a firmware that user uploaded. </param>
        /// <param name="vendor"> Firmware vendor. </param>
        /// <param name="model"> Firmware model. </param>
        /// <param name="version"> Firmware version. </param>
        /// <param name="description"> User-specified description of the firmware. </param>
        /// <param name="fileSize"> File size of the uploaded firmware image. </param>
        /// <param name="status"> The status of firmware scan. </param>
        /// <param name="statusMessages"> A list of errors or other messages generated during firmware analysis. </param>
        /// <param name="provisioningState"> Provisioning state of the resource. </param>
        /// <returns> A new <see cref="IotFirmwareDefense.IotFirmwareData"/> instance for mocking. </returns>
        public static IotFirmwareData IotFirmwareData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string fileName = null, string vendor = null, string model = null, string version = null, string description = null, long? fileSize = null, FirmwareAnalysisStatus? status = null, IEnumerable<FirmwareAnalysisStatusMessage> statusMessages = null, FirmwareProvisioningState? provisioningState = null)
        {
            statusMessages ??= new List<FirmwareAnalysisStatusMessage>();

            return new IotFirmwareData(
                id,
                name,
                resourceType,
                systemData,
                fileName,
                vendor,
                model,
                version,
                description,
                fileSize,
                status,
                statusMessages?.ToList(),
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.IotFirmwarePatch"/>. </summary>
        /// <param name="fileName"> File name for a firmware that user uploaded. </param>
        /// <param name="vendor"> Firmware vendor. </param>
        /// <param name="model"> Firmware model. </param>
        /// <param name="version"> Firmware version. </param>
        /// <param name="description"> User-specified description of the firmware. </param>
        /// <param name="fileSize"> File size of the uploaded firmware image. </param>
        /// <param name="status"> The status of firmware scan. </param>
        /// <param name="statusMessages"> A list of errors or other messages generated during firmware analysis. </param>
        /// <param name="provisioningState"> Provisioning state of the resource. </param>
        /// <returns> A new <see cref="Models.IotFirmwarePatch"/> instance for mocking. </returns>
        public static IotFirmwarePatch IotFirmwarePatch(string fileName = null, string vendor = null, string model = null, string version = null, string description = null, long? fileSize = null, FirmwareAnalysisStatus? status = null, IEnumerable<FirmwareAnalysisStatusMessage> statusMessages = null, FirmwareProvisioningState? provisioningState = null)
        {
            statusMessages ??= new List<FirmwareAnalysisStatusMessage>();

            return new IotFirmwarePatch(
                fileName,
                vendor,
                model,
                version,
                description,
                fileSize,
                status,
                statusMessages?.ToList(),
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.FirmwareUriToken"/>. </summary>
        /// <param name="uri"> SAS URL for creating or accessing a blob file. </param>
        /// <returns> A new <see cref="Models.FirmwareUriToken"/> instance for mocking. </returns>
        public static FirmwareUriToken FirmwareUriToken(Uri uri = null)
        {
            return new FirmwareUriToken(uri, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PasswordHashResult"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="passwordHashId"> ID for password hash. </param>
        /// <param name="filePath"> File path of the password hash. </param>
        /// <param name="salt"> Salt of the password hash. </param>
        /// <param name="hash"> Hash of the password. </param>
        /// <param name="context"> Context of password hash. </param>
        /// <param name="username"> User name of password hash. </param>
        /// <param name="algorithm"> Algorithm of the password hash. </param>
        /// <returns> A new <see cref="Models.PasswordHashResult"/> instance for mocking. </returns>
        public static PasswordHashResult PasswordHashResult(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string passwordHashId = null, string filePath = null, string salt = null, string hash = null, string context = null, string username = null, string algorithm = null)
        {
            return new PasswordHashResult(
                id,
                name,
                resourceType,
                systemData,
                passwordHashId,
                filePath,
                salt,
                hash,
                context,
                username,
                algorithm,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SbomComponentResult"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="componentId"> ID for the component. </param>
        /// <param name="componentName"> Name for the component. </param>
        /// <param name="version"> Version for the component. </param>
        /// <param name="license"> License for the component. </param>
        /// <param name="filePaths"> File paths related to the component. </param>
        /// <returns> A new <see cref="Models.SbomComponentResult"/> instance for mocking. </returns>
        public static SbomComponentResult SbomComponentResult(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string componentId = null, string componentName = null, string version = null, string license = null, IEnumerable<string> filePaths = null)
        {
            filePaths ??= new List<string>();

            return new SbomComponentResult(
                id,
                name,
                resourceType,
                systemData,
                componentId,
                componentName,
                version,
                license,
                filePaths?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="IotFirmwareDefense.FirmwareAnalysisSummaryData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties">
        /// Properties of an analysis summary.
        /// Please note <see cref="FirmwareAnalysisSummaryProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.BinaryHardeningSummary"/>, <see cref="Models.CryptoCertificateSummary"/>, <see cref="Models.CryptoKeySummary"/>, <see cref="Models.CveSummary"/> and <see cref="Models.FirmwareSummary"/>.
        /// </param>
        /// <returns> A new <see cref="IotFirmwareDefense.FirmwareAnalysisSummaryData"/> instance for mocking. </returns>
        public static FirmwareAnalysisSummaryData FirmwareAnalysisSummaryData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, FirmwareAnalysisSummaryProperties properties = null)
        {
            return new FirmwareAnalysisSummaryData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="IotFirmwareDefense.FirmwareAnalysisWorkspaceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="provisioningState"> Provisioning state of the resource. </param>
        /// <returns> A new <see cref="IotFirmwareDefense.FirmwareAnalysisWorkspaceData"/> instance for mocking. </returns>
        public static FirmwareAnalysisWorkspaceData FirmwareAnalysisWorkspaceData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, FirmwareProvisioningState? provisioningState = null)
        {
            tags ??= new Dictionary<string, string>();

            return new FirmwareAnalysisWorkspaceData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.FirmwareAnalysisWorkspacePatch"/>. </summary>
        /// <param name="provisioningState"> Provisioning state of the resource. </param>
        /// <returns> A new <see cref="Models.FirmwareAnalysisWorkspacePatch"/> instance for mocking. </returns>
        public static FirmwareAnalysisWorkspacePatch FirmwareAnalysisWorkspacePatch(FirmwareProvisioningState? provisioningState = null)
        {
            return new FirmwareAnalysisWorkspacePatch(provisioningState, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.FirmwareSummary"/>. </summary>
        /// <param name="extractedSize"> Total extracted size of the firmware in bytes. </param>
        /// <param name="fileSize"> Firmware file size in bytes. </param>
        /// <param name="extractedFileCount"> Extracted file count. </param>
        /// <param name="componentCount"> Components count. </param>
        /// <param name="binaryCount"> Binary count. </param>
        /// <param name="analysisTimeSeconds"> Time used for analysis. </param>
        /// <param name="rootFileSystems"> The number of root file systems found. </param>
        /// <returns> A new <see cref="Models.FirmwareSummary"/> instance for mocking. </returns>
        public static FirmwareSummary FirmwareSummary(long? extractedSize = null, long? fileSize = null, long? extractedFileCount = null, long? componentCount = null, long? binaryCount = null, long? analysisTimeSeconds = null, long? rootFileSystems = null)
        {
            return new FirmwareSummary(
                FirmwareAnalysisSummaryType.Firmware,
                serializedAdditionalRawData: null,
                extractedSize,
                fileSize,
                extractedFileCount,
                componentCount,
                binaryCount,
                analysisTimeSeconds,
                rootFileSystems);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CveSummary"/>. </summary>
        /// <param name="critical"> The total number of critical severity CVEs detected. </param>
        /// <param name="high"> The total number of high severity CVEs detected. </param>
        /// <param name="medium"> The total number of medium severity CVEs detected. </param>
        /// <param name="low"> The total number of low severity CVEs detected. </param>
        /// <param name="unknown"> The total number of unknown severity CVEs detected. </param>
        /// <returns> A new <see cref="Models.CveSummary"/> instance for mocking. </returns>
        public static CveSummary CveSummary(long? critical = null, long? high = null, long? medium = null, long? low = null, long? unknown = null)
        {
            return new CveSummary(
                FirmwareAnalysisSummaryType.Cve,
                serializedAdditionalRawData: null,
                critical,
                high,
                medium,
                low,
                unknown);
        }

        /// <summary> Initializes a new instance of <see cref="Models.BinaryHardeningSummary"/>. </summary>
        /// <param name="totalFiles"> Total number of binaries that were analyzed. </param>
        /// <param name="nxPercentage"> NX summary percentage. </param>
        /// <param name="piePercentage"> PIE summary percentage. </param>
        /// <param name="relroPercentage"> RELRO summary percentage. </param>
        /// <param name="canaryPercentage"> Canary summary percentage. </param>
        /// <param name="strippedPercentage"> Stripped summary percentage. </param>
        /// <returns> A new <see cref="Models.BinaryHardeningSummary"/> instance for mocking. </returns>
        public static BinaryHardeningSummary BinaryHardeningSummary(long? totalFiles = null, int? nxPercentage = null, int? piePercentage = null, int? relroPercentage = null, int? canaryPercentage = null, int? strippedPercentage = null)
        {
            return new BinaryHardeningSummary(
                FirmwareAnalysisSummaryType.BinaryHardening,
                serializedAdditionalRawData: null,
                totalFiles,
                nxPercentage,
                piePercentage,
                relroPercentage,
                canaryPercentage,
                strippedPercentage);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CryptoCertificateSummary"/>. </summary>
        /// <param name="totalCertificates"> Total number of certificates found. </param>
        /// <param name="pairedKeys"> Total number of paired private keys found for the certificates. </param>
        /// <param name="expired"> Total number of expired certificates found. </param>
        /// <param name="expiringSoon"> Total number of nearly expired certificates found. </param>
        /// <param name="weakSignature"> Total number of certificates found using a weak signature algorithm. </param>
        /// <param name="selfSigned"> Total number of certificates found that are self-signed. </param>
        /// <param name="shortKeySize"> Total number of certificates found that have an insecure key size for the key algorithm. </param>
        /// <returns> A new <see cref="Models.CryptoCertificateSummary"/> instance for mocking. </returns>
        public static CryptoCertificateSummary CryptoCertificateSummary(long? totalCertificates = null, long? pairedKeys = null, long? expired = null, long? expiringSoon = null, long? weakSignature = null, long? selfSigned = null, long? shortKeySize = null)
        {
            return new CryptoCertificateSummary(
                FirmwareAnalysisSummaryType.CryptoCertificate,
                serializedAdditionalRawData: null,
                totalCertificates,
                pairedKeys,
                expired,
                expiringSoon,
                weakSignature,
                selfSigned,
                shortKeySize);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CryptoKeySummary"/>. </summary>
        /// <param name="totalKeys"> Total number of cryptographic keys found. </param>
        /// <param name="publicKeys"> Total number of (non-certificate) public keys found. </param>
        /// <param name="privateKeys"> Total number of private keys found. </param>
        /// <param name="pairedKeys"> Total number of keys found that have a matching paired key or certificate. </param>
        /// <param name="shortKeySize"> Total number of keys found that have an insecure key size for the algorithm. </param>
        /// <returns> A new <see cref="Models.CryptoKeySummary"/> instance for mocking. </returns>
        public static CryptoKeySummary CryptoKeySummary(long? totalKeys = null, long? publicKeys = null, long? privateKeys = null, long? pairedKeys = null, long? shortKeySize = null)
        {
            return new CryptoKeySummary(
                FirmwareAnalysisSummaryType.CryptoKey,
                serializedAdditionalRawData: null,
                totalKeys,
                publicKeys,
                privateKeys,
                pairedKeys,
                shortKeySize);
        }
    }
}
