// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using Azure.Core;

namespace Azure.IoT.Hub.Service.Models
{
    public partial class X509Thumbprint : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            if (Optional.IsDefined(PrimaryThumbprint))
            {
                writer.WritePropertyName("primaryThumbprint"u8);
                writer.WriteStringValue(PrimaryThumbprint);
            }
            if (Optional.IsDefined(SecondaryThumbprint))
            {
                writer.WritePropertyName("secondaryThumbprint"u8);
                writer.WriteStringValue(SecondaryThumbprint);
            }
            writer.WriteEndObject();
        }

        internal static X509Thumbprint DeserializeX509Thumbprint(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string primaryThumbprint = default;
            string secondaryThumbprint = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("primaryThumbprint"u8))
                {
                    primaryThumbprint = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("secondaryThumbprint"u8))
                {
                    secondaryThumbprint = property.Value.GetString();
                    continue;
                }
            }
            return new X509Thumbprint(primaryThumbprint, secondaryThumbprint);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static X509Thumbprint FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeX509Thumbprint(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }
    }
}
