// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.IoT.Hub.Service.Models
{
    public partial class ServiceStatistics
    {
        internal static ServiceStatistics DeserializeServiceStatistics(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            long? connectedDeviceCount = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("connectedDeviceCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    connectedDeviceCount = property.Value.GetInt64();
                    continue;
                }
            }
            return new ServiceStatistics(connectedDeviceCount);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static ServiceStatistics FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeServiceStatistics(document.RootElement);
        }
    }
}
