// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.IoT.Hub.Service.Models
{
    /// <summary> The result of a device message queue purge operation. </summary>
    public partial class PurgeMessageQueueResult
    {
        /// <summary> Initializes a new instance of <see cref="PurgeMessageQueueResult"/>. </summary>
        internal PurgeMessageQueueResult()
        {
        }

        /// <summary> Initializes a new instance of <see cref="PurgeMessageQueueResult"/>. </summary>
        /// <param name="totalMessagesPurged"> The total number of messages purged. </param>
        /// <param name="deviceId"> The unique identifier of the device. </param>
        /// <param name="moduleId"> The unique identifier of the module. </param>
        internal PurgeMessageQueueResult(int? totalMessagesPurged, string deviceId, string moduleId)
        {
            TotalMessagesPurged = totalMessagesPurged;
            DeviceId = deviceId;
            ModuleId = moduleId;
        }

        /// <summary> The total number of messages purged. </summary>
        public int? TotalMessagesPurged { get; }
        /// <summary> The unique identifier of the device. </summary>
        public string DeviceId { get; }
        /// <summary> The unique identifier of the module. </summary>
        public string ModuleId { get; }
    }
}
