// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using Azure.Core;

namespace Azure.IoT.Hub.Service.Models
{
    public partial class JobRequest : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            if (Optional.IsDefined(JobId))
            {
                writer.WritePropertyName("jobId"u8);
                writer.WriteStringValue(JobId);
            }
            if (Optional.IsDefined(Type))
            {
                writer.WritePropertyName("type"u8);
                writer.WriteStringValue(Type.Value.ToString());
            }
            if (Optional.IsDefined(CloudToDeviceMethod))
            {
                writer.WritePropertyName("cloudToDeviceMethod"u8);
                writer.WriteObjectValue(CloudToDeviceMethod);
            }
            if (Optional.IsDefined(UpdateTwin))
            {
                writer.WritePropertyName("updateTwin"u8);
                writer.WriteObjectValue(UpdateTwin);
            }
            if (Optional.IsDefined(QueryCondition))
            {
                writer.WritePropertyName("queryCondition"u8);
                writer.WriteStringValue(QueryCondition);
            }
            if (Optional.IsDefined(StartTime))
            {
                writer.WritePropertyName("startTime"u8);
                writer.WriteStringValue(StartTime.Value, "O");
            }
            if (Optional.IsDefined(MaxExecutionTimeInSeconds))
            {
                writer.WritePropertyName("maxExecutionTimeInSeconds"u8);
                writer.WriteNumberValue(MaxExecutionTimeInSeconds.Value);
            }
            writer.WriteEndObject();
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }
    }
}
