// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.IoT.Hub.Service.Models
{
    /// <summary> The JobProperties. </summary>
    public partial class JobProperties
    {
        /// <summary> Initializes a new instance of <see cref="JobProperties"/>. </summary>
        public JobProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="JobProperties"/>. </summary>
        /// <param name="jobId"> The unique identifier of the job. </param>
        /// <param name="startTimeUtc"> System generated. Ignored at creation. The start date and time of the job in UTC. </param>
        /// <param name="endTimeUtc"> System generated. Ignored at creation. The end date and time of the job in UTC. </param>
        /// <param name="type"> The job type. </param>
        /// <param name="status"> System generated. Ignored at creation. The status of the job. </param>
        /// <param name="progress"> System generated. Ignored at creation. The percentage of job completion. </param>
        /// <param name="inputBlobContainerUri"> The URI containing SAS token to a blob container that contains registry data to sync. </param>
        /// <param name="inputBlobName"> The blob name to use when importing from the input blob container. </param>
        /// <param name="outputBlobContainerUri"> The SAS token to access the blob container. This is used to output the status and results of the job. </param>
        /// <param name="outputBlobName"> The blob name that will be created in the output blob container. This blob will contain the exported device registry information for the IoT Hub. </param>
        /// <param name="excludeKeysInExport"> Optional for export jobs; ignored for other jobs. If not specified, the service defaults to false. If false, authorization keys are included in export output. Keys are exported as null otherwise. </param>
        /// <param name="storageAuthenticationType"> The authentication type used for connecting to the storage account. </param>
        /// <param name="failureReason"> System genereated.  Ignored at creation. The reason for failure, if a failure occurred. </param>
        /// <param name="includeConfigurations"> Defaults to false. If true, then configurations are included in the data export/import. </param>
        /// <param name="configurationsBlobName"> Defaults to configurations.txt. Specifies the name of the blob to use when exporting/importing configurations. </param>
        internal JobProperties(string jobId, DateTimeOffset? startTimeUtc, DateTimeOffset? endTimeUtc, JobPropertiesType? type, JobPropertiesStatus? status, int? progress, string inputBlobContainerUri, string inputBlobName, string outputBlobContainerUri, string outputBlobName, bool? excludeKeysInExport, JobPropertiesStorageAuthenticationType? storageAuthenticationType, string failureReason, bool? includeConfigurations, string configurationsBlobName)
        {
            JobId = jobId;
            StartTimeUtc = startTimeUtc;
            EndTimeUtc = endTimeUtc;
            Type = type;
            Status = status;
            Progress = progress;
            InputBlobContainerUri = inputBlobContainerUri;
            InputBlobName = inputBlobName;
            OutputBlobContainerUri = outputBlobContainerUri;
            OutputBlobName = outputBlobName;
            ExcludeKeysInExport = excludeKeysInExport;
            StorageAuthenticationType = storageAuthenticationType;
            FailureReason = failureReason;
            IncludeConfigurations = includeConfigurations;
            ConfigurationsBlobName = configurationsBlobName;
        }

        /// <summary> The unique identifier of the job. </summary>
        public string JobId { get; set; }
        /// <summary> System generated. Ignored at creation. The start date and time of the job in UTC. </summary>
        public DateTimeOffset? StartTimeUtc { get; set; }
        /// <summary> System generated. Ignored at creation. The end date and time of the job in UTC. </summary>
        public DateTimeOffset? EndTimeUtc { get; set; }
        /// <summary> The job type. </summary>
        public JobPropertiesType? Type { get; set; }
        /// <summary> System generated. Ignored at creation. The status of the job. </summary>
        public JobPropertiesStatus? Status { get; set; }
        /// <summary> System generated. Ignored at creation. The percentage of job completion. </summary>
        public int? Progress { get; set; }
        /// <summary> The URI containing SAS token to a blob container that contains registry data to sync. </summary>
        public string InputBlobContainerUri { get; set; }
        /// <summary> The blob name to use when importing from the input blob container. </summary>
        public string InputBlobName { get; set; }
        /// <summary> The SAS token to access the blob container. This is used to output the status and results of the job. </summary>
        public string OutputBlobContainerUri { get; set; }
        /// <summary> The blob name that will be created in the output blob container. This blob will contain the exported device registry information for the IoT Hub. </summary>
        public string OutputBlobName { get; set; }
        /// <summary> Optional for export jobs; ignored for other jobs. If not specified, the service defaults to false. If false, authorization keys are included in export output. Keys are exported as null otherwise. </summary>
        public bool? ExcludeKeysInExport { get; set; }
        /// <summary> The authentication type used for connecting to the storage account. </summary>
        public JobPropertiesStorageAuthenticationType? StorageAuthenticationType { get; set; }
        /// <summary> System genereated.  Ignored at creation. The reason for failure, if a failure occurred. </summary>
        public string FailureReason { get; set; }
        /// <summary> Defaults to false. If true, then configurations are included in the data export/import. </summary>
        public bool? IncludeConfigurations { get; set; }
        /// <summary> Defaults to configurations.txt. Specifies the name of the blob to use when exporting/importing configurations. </summary>
        public string ConfigurationsBlobName { get; set; }
    }
}
