// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.IoT.Hub.Service.Models
{
    /// <summary> The status of the module. If disabled, the module cannot connect to the service. </summary>
    public readonly partial struct ExportImportDeviceStatus : IEquatable<ExportImportDeviceStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ExportImportDeviceStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ExportImportDeviceStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "enabled";
        private const string DisabledValue = "disabled";

        /// <summary> enabled. </summary>
        public static ExportImportDeviceStatus Enabled { get; } = new ExportImportDeviceStatus(EnabledValue);
        /// <summary> disabled. </summary>
        public static ExportImportDeviceStatus Disabled { get; } = new ExportImportDeviceStatus(DisabledValue);
        /// <summary> Determines if two <see cref="ExportImportDeviceStatus"/> values are the same. </summary>
        public static bool operator ==(ExportImportDeviceStatus left, ExportImportDeviceStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ExportImportDeviceStatus"/> values are not the same. </summary>
        public static bool operator !=(ExportImportDeviceStatus left, ExportImportDeviceStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ExportImportDeviceStatus"/>. </summary>
        public static implicit operator ExportImportDeviceStatus(string value) => new ExportImportDeviceStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ExportImportDeviceStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ExportImportDeviceStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
