// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.IoT.Hub.Service.Models
{
    /// <summary> The type of registry operation and ETag preferences. </summary>
    public readonly partial struct ExportImportDeviceImportMode : IEquatable<ExportImportDeviceImportMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ExportImportDeviceImportMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ExportImportDeviceImportMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CreateValue = "create";
        private const string UpdateValue = "update";
        private const string UpdateIfMatchETagValue = "updateIfMatchETag";
        private const string DeleteValue = "delete";
        private const string DeleteIfMatchETagValue = "deleteIfMatchETag";
        private const string UpdateTwinValue = "updateTwin";
        private const string UpdateTwinIfMatchETagValue = "updateTwinIfMatchETag";

        /// <summary> create. </summary>
        public static ExportImportDeviceImportMode Create { get; } = new ExportImportDeviceImportMode(CreateValue);
        /// <summary> update. </summary>
        public static ExportImportDeviceImportMode Update { get; } = new ExportImportDeviceImportMode(UpdateValue);
        /// <summary> updateIfMatchETag. </summary>
        public static ExportImportDeviceImportMode UpdateIfMatchETag { get; } = new ExportImportDeviceImportMode(UpdateIfMatchETagValue);
        /// <summary> delete. </summary>
        public static ExportImportDeviceImportMode Delete { get; } = new ExportImportDeviceImportMode(DeleteValue);
        /// <summary> deleteIfMatchETag. </summary>
        public static ExportImportDeviceImportMode DeleteIfMatchETag { get; } = new ExportImportDeviceImportMode(DeleteIfMatchETagValue);
        /// <summary> updateTwin. </summary>
        public static ExportImportDeviceImportMode UpdateTwin { get; } = new ExportImportDeviceImportMode(UpdateTwinValue);
        /// <summary> updateTwinIfMatchETag. </summary>
        public static ExportImportDeviceImportMode UpdateTwinIfMatchETag { get; } = new ExportImportDeviceImportMode(UpdateTwinIfMatchETagValue);
        /// <summary> Determines if two <see cref="ExportImportDeviceImportMode"/> values are the same. </summary>
        public static bool operator ==(ExportImportDeviceImportMode left, ExportImportDeviceImportMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ExportImportDeviceImportMode"/> values are not the same. </summary>
        public static bool operator !=(ExportImportDeviceImportMode left, ExportImportDeviceImportMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ExportImportDeviceImportMode"/>. </summary>
        public static implicit operator ExportImportDeviceImportMode(string value) => new ExportImportDeviceImportMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ExportImportDeviceImportMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ExportImportDeviceImportMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
