// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.IoT.Hub.Service.Models
{
    /// <summary> The RegistryStatistics. </summary>
    public partial class DevicesStatistics
    {
        /// <summary> Initializes a new instance of <see cref="DevicesStatistics"/>. </summary>
        internal DevicesStatistics()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DevicesStatistics"/>. </summary>
        /// <param name="totalDeviceCount"> The total number of devices registered for the IoT Hub. </param>
        /// <param name="enabledDeviceCount"> The number of currently enabled devices. </param>
        /// <param name="disabledDeviceCount"> The number of currently disabled devices. </param>
        internal DevicesStatistics(long? totalDeviceCount, long? enabledDeviceCount, long? disabledDeviceCount)
        {
            TotalDeviceCount = totalDeviceCount;
            EnabledDeviceCount = enabledDeviceCount;
            DisabledDeviceCount = disabledDeviceCount;
        }

        /// <summary> The total number of devices registered for the IoT Hub. </summary>
        public long? TotalDeviceCount { get; }
        /// <summary> The number of currently enabled devices. </summary>
        public long? EnabledDeviceCount { get; }
        /// <summary> The number of currently disabled devices. </summary>
        public long? DisabledDeviceCount { get; }
    }
}
