// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.IoT.Hub.Service.Models
{
    /// <summary> The warning code. </summary>
    public readonly partial struct DeviceRegistryOperationWarningCode : IEquatable<DeviceRegistryOperationWarningCode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DeviceRegistryOperationWarningCode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DeviceRegistryOperationWarningCode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DeviceRegisteredWithoutTwinValue = "DeviceRegisteredWithoutTwin";

        /// <summary> DeviceRegisteredWithoutTwin. </summary>
        public static DeviceRegistryOperationWarningCode DeviceRegisteredWithoutTwin { get; } = new DeviceRegistryOperationWarningCode(DeviceRegisteredWithoutTwinValue);
        /// <summary> Determines if two <see cref="DeviceRegistryOperationWarningCode"/> values are the same. </summary>
        public static bool operator ==(DeviceRegistryOperationWarningCode left, DeviceRegistryOperationWarningCode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DeviceRegistryOperationWarningCode"/> values are not the same. </summary>
        public static bool operator !=(DeviceRegistryOperationWarningCode left, DeviceRegistryOperationWarningCode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DeviceRegistryOperationWarningCode"/>. </summary>
        public static implicit operator DeviceRegistryOperationWarningCode(string value) => new DeviceRegistryOperationWarningCode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DeviceRegistryOperationWarningCode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DeviceRegistryOperationWarningCode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
