// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.IoT.Hub.Service.Models
{
    /// <summary> The device registry operation warning details. </summary>
    public partial class DeviceRegistryOperationWarning
    {
        /// <summary> Initializes a new instance of <see cref="DeviceRegistryOperationWarning"/>. </summary>
        internal DeviceRegistryOperationWarning()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DeviceRegistryOperationWarning"/>. </summary>
        /// <param name="deviceId"> The unique identifier of the device. </param>
        /// <param name="warningCode"> The warning code. </param>
        /// <param name="warningStatus"> The details of the warning. </param>
        internal DeviceRegistryOperationWarning(string deviceId, DeviceRegistryOperationWarningCode? warningCode, string warningStatus)
        {
            DeviceId = deviceId;
            WarningCode = warningCode;
            WarningStatus = warningStatus;
        }

        /// <summary> The unique identifier of the device. </summary>
        public string DeviceId { get; }
        /// <summary> The warning code. </summary>
        public DeviceRegistryOperationWarningCode? WarningCode { get; }
        /// <summary> The details of the warning. </summary>
        public string WarningStatus { get; }
    }
}
