// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.IoT.Hub.Service.Models
{
    public partial class DeviceRegistryOperationWarning
    {
        internal static DeviceRegistryOperationWarning DeserializeDeviceRegistryOperationWarning(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string deviceId = default;
            DeviceRegistryOperationWarningCode? warningCode = default;
            string warningStatus = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("deviceId"u8))
                {
                    deviceId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("warningCode"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    warningCode = new DeviceRegistryOperationWarningCode(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("warningStatus"u8))
                {
                    warningStatus = property.Value.GetString();
                    continue;
                }
            }
            return new DeviceRegistryOperationWarning(deviceId, warningCode, warningStatus);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static DeviceRegistryOperationWarning FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeDeviceRegistryOperationWarning(document.RootElement);
        }
    }
}
