// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.IoT.Hub.Service.Models
{
    /// <summary> The error code. </summary>
    public readonly partial struct DeviceRegistryOperationErrorCode : IEquatable<DeviceRegistryOperationErrorCode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DeviceRegistryOperationErrorCode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DeviceRegistryOperationErrorCode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InvalidErrorCodeValue = "InvalidErrorCode";
        private const string GenericBadRequestValue = "GenericBadRequest";
        private const string InvalidProtocolVersionValue = "InvalidProtocolVersion";
        private const string DeviceInvalidResultCountValue = "DeviceInvalidResultCount";
        private const string InvalidOperationValue = "InvalidOperation";
        private const string ArgumentInvalidValue = "ArgumentInvalid";
        private const string ArgumentNullValue = "ArgumentNull";
        private const string IotHubFormatErrorValue = "IotHubFormatError";
        private const string DeviceStorageEntitySerializationErrorValue = "DeviceStorageEntitySerializationError";
        private const string BlobContainerValidationErrorValue = "BlobContainerValidationError";
        private const string ImportWarningExistsErrorValue = "ImportWarningExistsError";
        private const string InvalidSchemaVersionValue = "InvalidSchemaVersion";
        private const string DeviceDefinedMultipleTimesValue = "DeviceDefinedMultipleTimes";
        private const string DeserializationErrorValue = "DeserializationError";
        private const string BulkRegistryOperationFailureValue = "BulkRegistryOperationFailure";
        private const string DefaultStorageEndpointNotConfiguredValue = "DefaultStorageEndpointNotConfigured";
        private const string InvalidFileUploadCorrelationIdValue = "InvalidFileUploadCorrelationId";
        private const string ExpiredFileUploadCorrelationIdValue = "ExpiredFileUploadCorrelationId";
        private const string InvalidStorageEndpointValue = "InvalidStorageEndpoint";
        private const string InvalidMessagingEndpointValue = "InvalidMessagingEndpoint";
        private const string InvalidFileUploadCompletionStatusValue = "InvalidFileUploadCompletionStatus";
        private const string InvalidStorageEndpointOrBlobValue = "InvalidStorageEndpointOrBlob";
        private const string RequestCanceledValue = "RequestCanceled";
        private const string InvalidStorageEndpointPropertyValue = "InvalidStorageEndpointProperty";
        private const string EtagDoesNotMatchValue = "EtagDoesNotMatch";
        private const string RequestTimedOutValue = "RequestTimedOut";
        private const string UnsupportedOperationOnReplicaValue = "UnsupportedOperationOnReplica";
        private const string NullMessageValue = "NullMessage";
        private const string ConnectionForcefullyClosedOnNewConnectionValue = "ConnectionForcefullyClosedOnNewConnection";
        private const string InvalidDeviceScopeValue = "InvalidDeviceScope";
        private const string ConnectionForcefullyClosedOnFaultInjectionValue = "ConnectionForcefullyClosedOnFaultInjection";
        private const string ConnectionRejectedOnFaultInjectionValue = "ConnectionRejectedOnFaultInjection";
        private const string InvalidEndpointAuthenticationTypeValue = "InvalidEndpointAuthenticationType";
        private const string ManagedIdentityNotEnabledValue = "ManagedIdentityNotEnabled";
        private const string InvalidRouteTestInputValue = "InvalidRouteTestInput";
        private const string InvalidSourceOnRouteValue = "InvalidSourceOnRoute";
        private const string RoutingNotEnabledValue = "RoutingNotEnabled";
        private const string InvalidContentEncodingOrTypeValue = "InvalidContentEncodingOrType";
        private const string InvalidEndorsementKeyValue = "InvalidEndorsementKey";
        private const string InvalidRegistrationIdValue = "InvalidRegistrationId";
        private const string InvalidStorageRootKeyValue = "InvalidStorageRootKey";
        private const string InvalidEnrollmentGroupIdValue = "InvalidEnrollmentGroupId";
        private const string TooManyEnrollmentsValue = "TooManyEnrollments";
        private const string RegistrationIdDefinedMultipleTimesValue = "RegistrationIdDefinedMultipleTimes";
        private const string CustomAllocationFailedValue = "CustomAllocationFailed";
        private const string CustomAllocationIotHubNotSpecifiedValue = "CustomAllocationIotHubNotSpecified";
        private const string CustomAllocationUnauthorizedAccessValue = "CustomAllocationUnauthorizedAccess";
        private const string CannotRegisterModuleToModuleValue = "CannotRegisterModuleToModule";
        private const string TenantHubRoutingNotEnabledValue = "TenantHubRoutingNotEnabled";
        private const string InvalidConfigurationTargetConditionValue = "InvalidConfigurationTargetCondition";
        private const string InvalidConfigurationContentValue = "InvalidConfigurationContent";
        private const string CannotModifyImmutableConfigurationContentValue = "CannotModifyImmutableConfigurationContent";
        private const string InvalidConfigurationCustomMetricsQueryValue = "InvalidConfigurationCustomMetricsQuery";
        private const string InvalidPnPInterfaceDefinitionValue = "InvalidPnPInterfaceDefinition";
        private const string InvalidPnPDesiredPropertiesValue = "InvalidPnPDesiredProperties";
        private const string InvalidPnPReportedPropertiesValue = "InvalidPnPReportedProperties";
        private const string InvalidPnPWritableReportedPropertiesValue = "InvalidPnPWritableReportedProperties";
        private const string InvalidDigitalTwinJsonPatchValue = "InvalidDigitalTwinJsonPatch";
        private const string InvalidDigitalTwinPayloadValue = "InvalidDigitalTwinPayload";
        private const string InvalidDigitalTwinPatchValue = "InvalidDigitalTwinPatch";
        private const string InvalidDigitalTwinPatchPathValue = "InvalidDigitalTwinPatchPath";
        private const string GenericUnauthorizedValue = "GenericUnauthorized";
        private const string IotHubNotFoundValue = "IotHubNotFound";
        private const string IotHubUnauthorizedAccessValue = "IotHubUnauthorizedAccess";
        private const string IotHubUnauthorizedValue = "IotHubUnauthorized";
        private const string ElasticPoolNotFoundValue = "ElasticPoolNotFound";
        private const string SystemModuleModifyUnauthorizedAccessValue = "SystemModuleModifyUnauthorizedAccess";
        private const string GenericForbiddenValue = "GenericForbidden";
        private const string IotHubSuspendedValue = "IotHubSuspended";
        private const string IotHubQuotaExceededValue = "IotHubQuotaExceeded";
        private const string JobQuotaExceededValue = "JobQuotaExceeded";
        private const string DeviceMaximumQueueDepthExceededValue = "DeviceMaximumQueueDepthExceeded";
        private const string IotHubMaxCbsTokenExceededValue = "IotHubMaxCbsTokenExceeded";
        private const string DeviceMaximumActiveFileUploadLimitExceededValue = "DeviceMaximumActiveFileUploadLimitExceeded";
        private const string DeviceMaximumQueueSizeExceededValue = "DeviceMaximumQueueSizeExceeded";
        private const string RoutingEndpointResponseForbiddenValue = "RoutingEndpointResponseForbidden";
        private const string InvalidMessageExpiryTimeValue = "InvalidMessageExpiryTime";
        private const string OperationNotAvailableInCurrentTierValue = "OperationNotAvailableInCurrentTier";
        private const string KeyEncryptionKeyRevokedValue = "KeyEncryptionKeyRevoked";
        private const string DeviceModelMaxPropertiesExceededValue = "DeviceModelMaxPropertiesExceeded";
        private const string DeviceModelMaxIndexablePropertiesExceededValue = "DeviceModelMaxIndexablePropertiesExceeded";
        private const string IotDpsSuspendedValue = "IotDpsSuspended";
        private const string IotDpsSuspendingValue = "IotDpsSuspending";
        private const string GenericNotFoundValue = "GenericNotFound";
        private const string DeviceNotFoundValue = "DeviceNotFound";
        private const string JobNotFoundValue = "JobNotFound";
        private const string QuotaMetricNotFoundValue = "QuotaMetricNotFound";
        private const string SystemPropertyNotFoundValue = "SystemPropertyNotFound";
        private const string AmqpAddressNotFoundValue = "AmqpAddressNotFound";
        private const string RoutingEndpointResponseNotFoundValue = "RoutingEndpointResponseNotFound";
        private const string CertificateNotFoundValue = "CertificateNotFound";
        private const string ElasticPoolTenantHubNotFoundValue = "ElasticPoolTenantHubNotFound";
        private const string ModuleNotFoundValue = "ModuleNotFound";
        private const string AzureTableStoreNotFoundValue = "AzureTableStoreNotFound";
        private const string IotHubFailingOverValue = "IotHubFailingOver";
        private const string FeatureNotSupportedValue = "FeatureNotSupported";
        private const string DigitalTwinInterfaceNotFoundValue = "DigitalTwinInterfaceNotFound";
        private const string QueryStoreClusterNotFoundValue = "QueryStoreClusterNotFound";
        private const string DeviceNotOnlineValue = "DeviceNotOnline";
        private const string DeviceConnectionClosedRemotelyValue = "DeviceConnectionClosedRemotely";
        private const string EnrollmentNotFoundValue = "EnrollmentNotFound";
        private const string DeviceRegistrationNotFoundValue = "DeviceRegistrationNotFound";
        private const string AsyncOperationNotFoundValue = "AsyncOperationNotFound";
        private const string EnrollmentGroupNotFoundValue = "EnrollmentGroupNotFound";
        private const string DeviceRecordNotFoundValue = "DeviceRecordNotFound";
        private const string GroupRecordNotFoundValue = "GroupRecordNotFound";
        private const string DeviceGroupNotFoundValue = "DeviceGroupNotFound";
        private const string ProvisioningSettingsNotFoundValue = "ProvisioningSettingsNotFound";
        private const string ProvisioningRecordNotFoundValue = "ProvisioningRecordNotFound";
        private const string LinkedHubNotFoundValue = "LinkedHubNotFound";
        private const string CertificateAuthorityNotFoundValue = "CertificateAuthorityNotFound";
        private const string ConfigurationNotFoundValue = "ConfigurationNotFound";
        private const string GroupNotFoundValue = "GroupNotFound";
        private const string DigitalTwinModelNotFoundValue = "DigitalTwinModelNotFound";
        private const string InterfaceNameModelNotFoundValue = "InterfaceNameModelNotFound";
        private const string GenericMethodNotAllowedValue = "GenericMethodNotAllowed";
        private const string OperationNotAllowedInCurrentStateValue = "OperationNotAllowedInCurrentState";
        private const string ImportDevicesNotSupportedValue = "ImportDevicesNotSupported";
        private const string BulkAddDevicesNotSupportedValue = "BulkAddDevicesNotSupported";
        private const string GenericConflictValue = "GenericConflict";
        private const string DeviceAlreadyExistsValue = "DeviceAlreadyExists";
        private const string LinkCreationConflictValue = "LinkCreationConflict";
        private const string CallbackSubscriptionConflictValue = "CallbackSubscriptionConflict";
        private const string ModelAlreadyExistsValue = "ModelAlreadyExists";
        private const string DeviceLockedValue = "DeviceLocked";
        private const string DeviceJobAlreadyExistsValue = "DeviceJobAlreadyExists";
        private const string JobAlreadyExistsValue = "JobAlreadyExists";
        private const string EnrollmentConflictValue = "EnrollmentConflict";
        private const string EnrollmentGroupConflictValue = "EnrollmentGroupConflict";
        private const string RegistrationStatusConflictValue = "RegistrationStatusConflict";
        private const string DeviceRecordConflictValue = "DeviceRecordConflict";
        private const string GroupRecordConflictValue = "GroupRecordConflict";
        private const string DeviceGroupConflictValue = "DeviceGroupConflict";
        private const string ProvisioningSettingsConflictValue = "ProvisioningSettingsConflict";
        private const string ProvisioningRecordConflictValue = "ProvisioningRecordConflict";
        private const string LinkedHubConflictValue = "LinkedHubConflict";
        private const string CertificateAuthorityConflictValue = "CertificateAuthorityConflict";
        private const string ModuleAlreadyExistsOnDeviceValue = "ModuleAlreadyExistsOnDevice";
        private const string ConfigurationAlreadyExistsValue = "ConfigurationAlreadyExists";
        private const string ApplyConfigurationAlreadyInProgressOnDeviceValue = "ApplyConfigurationAlreadyInProgressOnDevice";
        private const string DigitalTwinModelAlreadyExistsValue = "DigitalTwinModelAlreadyExists";
        private const string DigitalTwinModelExistsWithOtherModelTypeValue = "DigitalTwinModelExistsWithOtherModelType";
        private const string InterfaceNameModelAlreadyExistsValue = "InterfaceNameModelAlreadyExists";
        private const string GenericPreconditionFailedValue = "GenericPreconditionFailed";
        private const string PreconditionFailedValue = "PreconditionFailed";
        private const string DeviceMessageLockLostValue = "DeviceMessageLockLost";
        private const string JobRunPreconditionFailedValue = "JobRunPreconditionFailed";
        private const string InflightMessagesInLinkValue = "InflightMessagesInLink";
        private const string GenericRequestEntityTooLargeValue = "GenericRequestEntityTooLarge";
        private const string MessageTooLargeValue = "MessageTooLarge";
        private const string TooManyDevicesValue = "TooManyDevices";
        private const string TooManyModulesOnDeviceValue = "TooManyModulesOnDevice";
        private const string ConfigurationCountLimitExceededValue = "ConfigurationCountLimitExceeded";
        private const string DigitalTwinModelCountLimitExceededValue = "DigitalTwinModelCountLimitExceeded";
        private const string InterfaceNameCompressionModelCountLimitExceededValue = "InterfaceNameCompressionModelCountLimitExceeded";
        private const string GenericUnsupportedMediaTypeValue = "GenericUnsupportedMediaType";
        private const string IncompatibleDataTypeValue = "IncompatibleDataType";
        private const string GenericTooManyRequestsValue = "GenericTooManyRequests";
        private const string ThrottlingExceptionValue = "ThrottlingException";
        private const string ThrottleBacklogLimitExceededValue = "ThrottleBacklogLimitExceeded";
        private const string ThrottlingBacklogTimeoutValue = "ThrottlingBacklogTimeout";
        private const string ThrottlingMaxActiveJobCountExceededValue = "ThrottlingMaxActiveJobCountExceeded";
        private const string DeviceThrottlingLimitExceededValue = "DeviceThrottlingLimitExceeded";
        private const string ClientClosedRequestValue = "ClientClosedRequest";
        private const string GenericServerErrorValue = "GenericServerError";
        private const string ServerErrorValue = "ServerError";
        private const string JobCancelledValue = "JobCancelled";
        private const string StatisticsRetrievalErrorValue = "StatisticsRetrievalError";
        private const string ConnectionForcefullyClosedValue = "ConnectionForcefullyClosed";
        private const string InvalidBlobStateValue = "InvalidBlobState";
        private const string BackupTimedOutValue = "BackupTimedOut";
        private const string AzureStorageTimeoutValue = "AzureStorageTimeout";
        private const string GenericTimeoutValue = "GenericTimeout";
        private const string InvalidThrottleParameterValue = "InvalidThrottleParameter";
        private const string EventHubLinkAlreadyClosedValue = "EventHubLinkAlreadyClosed";
        private const string ReliableBlobStoreErrorValue = "ReliableBlobStoreError";
        private const string RetryAttemptsExhaustedValue = "RetryAttemptsExhausted";
        private const string AzureTableStoreErrorValue = "AzureTableStoreError";
        private const string CheckpointStoreNotFoundValue = "CheckpointStoreNotFound";
        private const string DocumentDbInvalidReturnValueValue = "DocumentDbInvalidReturnValue";
        private const string ReliableDocDbStoreStoreErrorValue = "ReliableDocDbStoreStoreError";
        private const string ReliableBlobStoreTimeoutErrorValue = "ReliableBlobStoreTimeoutError";
        private const string ConfigReadFailedValue = "ConfigReadFailed";
        private const string InvalidContainerReceiveLinkValue = "InvalidContainerReceiveLink";
        private const string InvalidPartitionEpochValue = "InvalidPartitionEpoch";
        private const string RestoreTimedOutValue = "RestoreTimedOut";
        private const string StreamReservationFailureValue = "StreamReservationFailure";
        private const string SerializationErrorValue = "SerializationError";
        private const string UnexpectedPropertyValueValue = "UnexpectedPropertyValue";
        private const string OrchestrationOperationFailedValue = "OrchestrationOperationFailed";
        private const string ModelRepoEndpointErrorValue = "ModelRepoEndpointError";
        private const string ResolutionErrorValue = "ResolutionError";
        private const string UnableToFetchCredentialsValue = "UnableToFetchCredentials";
        private const string UnableToFetchTenantInfoValue = "UnableToFetchTenantInfo";
        private const string UnableToShareIdentityValue = "UnableToShareIdentity";
        private const string UnableToExpandDiscoveryInfoValue = "UnableToExpandDiscoveryInfo";
        private const string UnableToExpandComponentInfoValue = "UnableToExpandComponentInfo";
        private const string UnableToCompressComponentInfoValue = "UnableToCompressComponentInfo";
        private const string UnableToCompressDiscoveryInfoValue = "UnableToCompressDiscoveryInfo";
        private const string OrphanDiscoveryDocumentValue = "OrphanDiscoveryDocument";
        private const string GenericBadGatewayValue = "GenericBadGateway";
        private const string InvalidResponseWhileProxyingValue = "InvalidResponseWhileProxying";
        private const string GenericServiceUnavailableValue = "GenericServiceUnavailable";
        private const string ServiceUnavailableValue = "ServiceUnavailable";
        private const string PartitionNotFoundValue = "PartitionNotFound";
        private const string IotHubActivationFailedValue = "IotHubActivationFailed";
        private const string ServerBusyValue = "ServerBusy";
        private const string IotHubRestoringValue = "IotHubRestoring";
        private const string ReceiveLinkOpensThrottledValue = "ReceiveLinkOpensThrottled";
        private const string ConnectionUnavailableValue = "ConnectionUnavailable";
        private const string DeviceUnavailableValue = "DeviceUnavailable";
        private const string ConfigurationNotAvailableValue = "ConfigurationNotAvailable";
        private const string GroupNotAvailableValue = "GroupNotAvailable";
        private const string HostingServiceNotAvailableValue = "HostingServiceNotAvailable";
        private const string GenericGatewayTimeoutValue = "GenericGatewayTimeout";
        private const string GatewayTimeoutValue = "GatewayTimeout";

        /// <summary> InvalidErrorCode. </summary>
        public static DeviceRegistryOperationErrorCode InvalidErrorCode { get; } = new DeviceRegistryOperationErrorCode(InvalidErrorCodeValue);
        /// <summary> GenericBadRequest. </summary>
        public static DeviceRegistryOperationErrorCode GenericBadRequest { get; } = new DeviceRegistryOperationErrorCode(GenericBadRequestValue);
        /// <summary> InvalidProtocolVersion. </summary>
        public static DeviceRegistryOperationErrorCode InvalidProtocolVersion { get; } = new DeviceRegistryOperationErrorCode(InvalidProtocolVersionValue);
        /// <summary> DeviceInvalidResultCount. </summary>
        public static DeviceRegistryOperationErrorCode DeviceInvalidResultCount { get; } = new DeviceRegistryOperationErrorCode(DeviceInvalidResultCountValue);
        /// <summary> InvalidOperation. </summary>
        public static DeviceRegistryOperationErrorCode InvalidOperation { get; } = new DeviceRegistryOperationErrorCode(InvalidOperationValue);
        /// <summary> ArgumentInvalid. </summary>
        public static DeviceRegistryOperationErrorCode ArgumentInvalid { get; } = new DeviceRegistryOperationErrorCode(ArgumentInvalidValue);
        /// <summary> ArgumentNull. </summary>
        public static DeviceRegistryOperationErrorCode ArgumentNull { get; } = new DeviceRegistryOperationErrorCode(ArgumentNullValue);
        /// <summary> IotHubFormatError. </summary>
        public static DeviceRegistryOperationErrorCode IotHubFormatError { get; } = new DeviceRegistryOperationErrorCode(IotHubFormatErrorValue);
        /// <summary> DeviceStorageEntitySerializationError. </summary>
        public static DeviceRegistryOperationErrorCode DeviceStorageEntitySerializationError { get; } = new DeviceRegistryOperationErrorCode(DeviceStorageEntitySerializationErrorValue);
        /// <summary> BlobContainerValidationError. </summary>
        public static DeviceRegistryOperationErrorCode BlobContainerValidationError { get; } = new DeviceRegistryOperationErrorCode(BlobContainerValidationErrorValue);
        /// <summary> ImportWarningExistsError. </summary>
        public static DeviceRegistryOperationErrorCode ImportWarningExistsError { get; } = new DeviceRegistryOperationErrorCode(ImportWarningExistsErrorValue);
        /// <summary> InvalidSchemaVersion. </summary>
        public static DeviceRegistryOperationErrorCode InvalidSchemaVersion { get; } = new DeviceRegistryOperationErrorCode(InvalidSchemaVersionValue);
        /// <summary> DeviceDefinedMultipleTimes. </summary>
        public static DeviceRegistryOperationErrorCode DeviceDefinedMultipleTimes { get; } = new DeviceRegistryOperationErrorCode(DeviceDefinedMultipleTimesValue);
        /// <summary> DeserializationError. </summary>
        public static DeviceRegistryOperationErrorCode DeserializationError { get; } = new DeviceRegistryOperationErrorCode(DeserializationErrorValue);
        /// <summary> BulkRegistryOperationFailure. </summary>
        public static DeviceRegistryOperationErrorCode BulkRegistryOperationFailure { get; } = new DeviceRegistryOperationErrorCode(BulkRegistryOperationFailureValue);
        /// <summary> DefaultStorageEndpointNotConfigured. </summary>
        public static DeviceRegistryOperationErrorCode DefaultStorageEndpointNotConfigured { get; } = new DeviceRegistryOperationErrorCode(DefaultStorageEndpointNotConfiguredValue);
        /// <summary> InvalidFileUploadCorrelationId. </summary>
        public static DeviceRegistryOperationErrorCode InvalidFileUploadCorrelationId { get; } = new DeviceRegistryOperationErrorCode(InvalidFileUploadCorrelationIdValue);
        /// <summary> ExpiredFileUploadCorrelationId. </summary>
        public static DeviceRegistryOperationErrorCode ExpiredFileUploadCorrelationId { get; } = new DeviceRegistryOperationErrorCode(ExpiredFileUploadCorrelationIdValue);
        /// <summary> InvalidStorageEndpoint. </summary>
        public static DeviceRegistryOperationErrorCode InvalidStorageEndpoint { get; } = new DeviceRegistryOperationErrorCode(InvalidStorageEndpointValue);
        /// <summary> InvalidMessagingEndpoint. </summary>
        public static DeviceRegistryOperationErrorCode InvalidMessagingEndpoint { get; } = new DeviceRegistryOperationErrorCode(InvalidMessagingEndpointValue);
        /// <summary> InvalidFileUploadCompletionStatus. </summary>
        public static DeviceRegistryOperationErrorCode InvalidFileUploadCompletionStatus { get; } = new DeviceRegistryOperationErrorCode(InvalidFileUploadCompletionStatusValue);
        /// <summary> InvalidStorageEndpointOrBlob. </summary>
        public static DeviceRegistryOperationErrorCode InvalidStorageEndpointOrBlob { get; } = new DeviceRegistryOperationErrorCode(InvalidStorageEndpointOrBlobValue);
        /// <summary> RequestCanceled. </summary>
        public static DeviceRegistryOperationErrorCode RequestCanceled { get; } = new DeviceRegistryOperationErrorCode(RequestCanceledValue);
        /// <summary> InvalidStorageEndpointProperty. </summary>
        public static DeviceRegistryOperationErrorCode InvalidStorageEndpointProperty { get; } = new DeviceRegistryOperationErrorCode(InvalidStorageEndpointPropertyValue);
        /// <summary> EtagDoesNotMatch. </summary>
        public static DeviceRegistryOperationErrorCode EtagDoesNotMatch { get; } = new DeviceRegistryOperationErrorCode(EtagDoesNotMatchValue);
        /// <summary> RequestTimedOut. </summary>
        public static DeviceRegistryOperationErrorCode RequestTimedOut { get; } = new DeviceRegistryOperationErrorCode(RequestTimedOutValue);
        /// <summary> UnsupportedOperationOnReplica. </summary>
        public static DeviceRegistryOperationErrorCode UnsupportedOperationOnReplica { get; } = new DeviceRegistryOperationErrorCode(UnsupportedOperationOnReplicaValue);
        /// <summary> NullMessage. </summary>
        public static DeviceRegistryOperationErrorCode NullMessage { get; } = new DeviceRegistryOperationErrorCode(NullMessageValue);
        /// <summary> ConnectionForcefullyClosedOnNewConnection. </summary>
        public static DeviceRegistryOperationErrorCode ConnectionForcefullyClosedOnNewConnection { get; } = new DeviceRegistryOperationErrorCode(ConnectionForcefullyClosedOnNewConnectionValue);
        /// <summary> InvalidDeviceScope. </summary>
        public static DeviceRegistryOperationErrorCode InvalidDeviceScope { get; } = new DeviceRegistryOperationErrorCode(InvalidDeviceScopeValue);
        /// <summary> ConnectionForcefullyClosedOnFaultInjection. </summary>
        public static DeviceRegistryOperationErrorCode ConnectionForcefullyClosedOnFaultInjection { get; } = new DeviceRegistryOperationErrorCode(ConnectionForcefullyClosedOnFaultInjectionValue);
        /// <summary> ConnectionRejectedOnFaultInjection. </summary>
        public static DeviceRegistryOperationErrorCode ConnectionRejectedOnFaultInjection { get; } = new DeviceRegistryOperationErrorCode(ConnectionRejectedOnFaultInjectionValue);
        /// <summary> InvalidEndpointAuthenticationType. </summary>
        public static DeviceRegistryOperationErrorCode InvalidEndpointAuthenticationType { get; } = new DeviceRegistryOperationErrorCode(InvalidEndpointAuthenticationTypeValue);
        /// <summary> ManagedIdentityNotEnabled. </summary>
        public static DeviceRegistryOperationErrorCode ManagedIdentityNotEnabled { get; } = new DeviceRegistryOperationErrorCode(ManagedIdentityNotEnabledValue);
        /// <summary> InvalidRouteTestInput. </summary>
        public static DeviceRegistryOperationErrorCode InvalidRouteTestInput { get; } = new DeviceRegistryOperationErrorCode(InvalidRouteTestInputValue);
        /// <summary> InvalidSourceOnRoute. </summary>
        public static DeviceRegistryOperationErrorCode InvalidSourceOnRoute { get; } = new DeviceRegistryOperationErrorCode(InvalidSourceOnRouteValue);
        /// <summary> RoutingNotEnabled. </summary>
        public static DeviceRegistryOperationErrorCode RoutingNotEnabled { get; } = new DeviceRegistryOperationErrorCode(RoutingNotEnabledValue);
        /// <summary> InvalidContentEncodingOrType. </summary>
        public static DeviceRegistryOperationErrorCode InvalidContentEncodingOrType { get; } = new DeviceRegistryOperationErrorCode(InvalidContentEncodingOrTypeValue);
        /// <summary> InvalidEndorsementKey. </summary>
        public static DeviceRegistryOperationErrorCode InvalidEndorsementKey { get; } = new DeviceRegistryOperationErrorCode(InvalidEndorsementKeyValue);
        /// <summary> InvalidRegistrationId. </summary>
        public static DeviceRegistryOperationErrorCode InvalidRegistrationId { get; } = new DeviceRegistryOperationErrorCode(InvalidRegistrationIdValue);
        /// <summary> InvalidStorageRootKey. </summary>
        public static DeviceRegistryOperationErrorCode InvalidStorageRootKey { get; } = new DeviceRegistryOperationErrorCode(InvalidStorageRootKeyValue);
        /// <summary> InvalidEnrollmentGroupId. </summary>
        public static DeviceRegistryOperationErrorCode InvalidEnrollmentGroupId { get; } = new DeviceRegistryOperationErrorCode(InvalidEnrollmentGroupIdValue);
        /// <summary> TooManyEnrollments. </summary>
        public static DeviceRegistryOperationErrorCode TooManyEnrollments { get; } = new DeviceRegistryOperationErrorCode(TooManyEnrollmentsValue);
        /// <summary> RegistrationIdDefinedMultipleTimes. </summary>
        public static DeviceRegistryOperationErrorCode RegistrationIdDefinedMultipleTimes { get; } = new DeviceRegistryOperationErrorCode(RegistrationIdDefinedMultipleTimesValue);
        /// <summary> CustomAllocationFailed. </summary>
        public static DeviceRegistryOperationErrorCode CustomAllocationFailed { get; } = new DeviceRegistryOperationErrorCode(CustomAllocationFailedValue);
        /// <summary> CustomAllocationIotHubNotSpecified. </summary>
        public static DeviceRegistryOperationErrorCode CustomAllocationIotHubNotSpecified { get; } = new DeviceRegistryOperationErrorCode(CustomAllocationIotHubNotSpecifiedValue);
        /// <summary> CustomAllocationUnauthorizedAccess. </summary>
        public static DeviceRegistryOperationErrorCode CustomAllocationUnauthorizedAccess { get; } = new DeviceRegistryOperationErrorCode(CustomAllocationUnauthorizedAccessValue);
        /// <summary> CannotRegisterModuleToModule. </summary>
        public static DeviceRegistryOperationErrorCode CannotRegisterModuleToModule { get; } = new DeviceRegistryOperationErrorCode(CannotRegisterModuleToModuleValue);
        /// <summary> TenantHubRoutingNotEnabled. </summary>
        public static DeviceRegistryOperationErrorCode TenantHubRoutingNotEnabled { get; } = new DeviceRegistryOperationErrorCode(TenantHubRoutingNotEnabledValue);
        /// <summary> InvalidConfigurationTargetCondition. </summary>
        public static DeviceRegistryOperationErrorCode InvalidConfigurationTargetCondition { get; } = new DeviceRegistryOperationErrorCode(InvalidConfigurationTargetConditionValue);
        /// <summary> InvalidConfigurationContent. </summary>
        public static DeviceRegistryOperationErrorCode InvalidConfigurationContent { get; } = new DeviceRegistryOperationErrorCode(InvalidConfigurationContentValue);
        /// <summary> CannotModifyImmutableConfigurationContent. </summary>
        public static DeviceRegistryOperationErrorCode CannotModifyImmutableConfigurationContent { get; } = new DeviceRegistryOperationErrorCode(CannotModifyImmutableConfigurationContentValue);
        /// <summary> InvalidConfigurationCustomMetricsQuery. </summary>
        public static DeviceRegistryOperationErrorCode InvalidConfigurationCustomMetricsQuery { get; } = new DeviceRegistryOperationErrorCode(InvalidConfigurationCustomMetricsQueryValue);
        /// <summary> InvalidPnPInterfaceDefinition. </summary>
        public static DeviceRegistryOperationErrorCode InvalidPnPInterfaceDefinition { get; } = new DeviceRegistryOperationErrorCode(InvalidPnPInterfaceDefinitionValue);
        /// <summary> InvalidPnPDesiredProperties. </summary>
        public static DeviceRegistryOperationErrorCode InvalidPnPDesiredProperties { get; } = new DeviceRegistryOperationErrorCode(InvalidPnPDesiredPropertiesValue);
        /// <summary> InvalidPnPReportedProperties. </summary>
        public static DeviceRegistryOperationErrorCode InvalidPnPReportedProperties { get; } = new DeviceRegistryOperationErrorCode(InvalidPnPReportedPropertiesValue);
        /// <summary> InvalidPnPWritableReportedProperties. </summary>
        public static DeviceRegistryOperationErrorCode InvalidPnPWritableReportedProperties { get; } = new DeviceRegistryOperationErrorCode(InvalidPnPWritableReportedPropertiesValue);
        /// <summary> InvalidDigitalTwinJsonPatch. </summary>
        public static DeviceRegistryOperationErrorCode InvalidDigitalTwinJsonPatch { get; } = new DeviceRegistryOperationErrorCode(InvalidDigitalTwinJsonPatchValue);
        /// <summary> InvalidDigitalTwinPayload. </summary>
        public static DeviceRegistryOperationErrorCode InvalidDigitalTwinPayload { get; } = new DeviceRegistryOperationErrorCode(InvalidDigitalTwinPayloadValue);
        /// <summary> InvalidDigitalTwinPatch. </summary>
        public static DeviceRegistryOperationErrorCode InvalidDigitalTwinPatch { get; } = new DeviceRegistryOperationErrorCode(InvalidDigitalTwinPatchValue);
        /// <summary> InvalidDigitalTwinPatchPath. </summary>
        public static DeviceRegistryOperationErrorCode InvalidDigitalTwinPatchPath { get; } = new DeviceRegistryOperationErrorCode(InvalidDigitalTwinPatchPathValue);
        /// <summary> GenericUnauthorized. </summary>
        public static DeviceRegistryOperationErrorCode GenericUnauthorized { get; } = new DeviceRegistryOperationErrorCode(GenericUnauthorizedValue);
        /// <summary> IotHubNotFound. </summary>
        public static DeviceRegistryOperationErrorCode IotHubNotFound { get; } = new DeviceRegistryOperationErrorCode(IotHubNotFoundValue);
        /// <summary> IotHubUnauthorizedAccess. </summary>
        public static DeviceRegistryOperationErrorCode IotHubUnauthorizedAccess { get; } = new DeviceRegistryOperationErrorCode(IotHubUnauthorizedAccessValue);
        /// <summary> IotHubUnauthorized. </summary>
        public static DeviceRegistryOperationErrorCode IotHubUnauthorized { get; } = new DeviceRegistryOperationErrorCode(IotHubUnauthorizedValue);
        /// <summary> ElasticPoolNotFound. </summary>
        public static DeviceRegistryOperationErrorCode ElasticPoolNotFound { get; } = new DeviceRegistryOperationErrorCode(ElasticPoolNotFoundValue);
        /// <summary> SystemModuleModifyUnauthorizedAccess. </summary>
        public static DeviceRegistryOperationErrorCode SystemModuleModifyUnauthorizedAccess { get; } = new DeviceRegistryOperationErrorCode(SystemModuleModifyUnauthorizedAccessValue);
        /// <summary> GenericForbidden. </summary>
        public static DeviceRegistryOperationErrorCode GenericForbidden { get; } = new DeviceRegistryOperationErrorCode(GenericForbiddenValue);
        /// <summary> IotHubSuspended. </summary>
        public static DeviceRegistryOperationErrorCode IotHubSuspended { get; } = new DeviceRegistryOperationErrorCode(IotHubSuspendedValue);
        /// <summary> IotHubQuotaExceeded. </summary>
        public static DeviceRegistryOperationErrorCode IotHubQuotaExceeded { get; } = new DeviceRegistryOperationErrorCode(IotHubQuotaExceededValue);
        /// <summary> JobQuotaExceeded. </summary>
        public static DeviceRegistryOperationErrorCode JobQuotaExceeded { get; } = new DeviceRegistryOperationErrorCode(JobQuotaExceededValue);
        /// <summary> DeviceMaximumQueueDepthExceeded. </summary>
        public static DeviceRegistryOperationErrorCode DeviceMaximumQueueDepthExceeded { get; } = new DeviceRegistryOperationErrorCode(DeviceMaximumQueueDepthExceededValue);
        /// <summary> IotHubMaxCbsTokenExceeded. </summary>
        public static DeviceRegistryOperationErrorCode IotHubMaxCbsTokenExceeded { get; } = new DeviceRegistryOperationErrorCode(IotHubMaxCbsTokenExceededValue);
        /// <summary> DeviceMaximumActiveFileUploadLimitExceeded. </summary>
        public static DeviceRegistryOperationErrorCode DeviceMaximumActiveFileUploadLimitExceeded { get; } = new DeviceRegistryOperationErrorCode(DeviceMaximumActiveFileUploadLimitExceededValue);
        /// <summary> DeviceMaximumQueueSizeExceeded. </summary>
        public static DeviceRegistryOperationErrorCode DeviceMaximumQueueSizeExceeded { get; } = new DeviceRegistryOperationErrorCode(DeviceMaximumQueueSizeExceededValue);
        /// <summary> RoutingEndpointResponseForbidden. </summary>
        public static DeviceRegistryOperationErrorCode RoutingEndpointResponseForbidden { get; } = new DeviceRegistryOperationErrorCode(RoutingEndpointResponseForbiddenValue);
        /// <summary> InvalidMessageExpiryTime. </summary>
        public static DeviceRegistryOperationErrorCode InvalidMessageExpiryTime { get; } = new DeviceRegistryOperationErrorCode(InvalidMessageExpiryTimeValue);
        /// <summary> OperationNotAvailableInCurrentTier. </summary>
        public static DeviceRegistryOperationErrorCode OperationNotAvailableInCurrentTier { get; } = new DeviceRegistryOperationErrorCode(OperationNotAvailableInCurrentTierValue);
        /// <summary> KeyEncryptionKeyRevoked. </summary>
        public static DeviceRegistryOperationErrorCode KeyEncryptionKeyRevoked { get; } = new DeviceRegistryOperationErrorCode(KeyEncryptionKeyRevokedValue);
        /// <summary> DeviceModelMaxPropertiesExceeded. </summary>
        public static DeviceRegistryOperationErrorCode DeviceModelMaxPropertiesExceeded { get; } = new DeviceRegistryOperationErrorCode(DeviceModelMaxPropertiesExceededValue);
        /// <summary> DeviceModelMaxIndexablePropertiesExceeded. </summary>
        public static DeviceRegistryOperationErrorCode DeviceModelMaxIndexablePropertiesExceeded { get; } = new DeviceRegistryOperationErrorCode(DeviceModelMaxIndexablePropertiesExceededValue);
        /// <summary> IotDpsSuspended. </summary>
        public static DeviceRegistryOperationErrorCode IotDpsSuspended { get; } = new DeviceRegistryOperationErrorCode(IotDpsSuspendedValue);
        /// <summary> IotDpsSuspending. </summary>
        public static DeviceRegistryOperationErrorCode IotDpsSuspending { get; } = new DeviceRegistryOperationErrorCode(IotDpsSuspendingValue);
        /// <summary> GenericNotFound. </summary>
        public static DeviceRegistryOperationErrorCode GenericNotFound { get; } = new DeviceRegistryOperationErrorCode(GenericNotFoundValue);
        /// <summary> DeviceNotFound. </summary>
        public static DeviceRegistryOperationErrorCode DeviceNotFound { get; } = new DeviceRegistryOperationErrorCode(DeviceNotFoundValue);
        /// <summary> JobNotFound. </summary>
        public static DeviceRegistryOperationErrorCode JobNotFound { get; } = new DeviceRegistryOperationErrorCode(JobNotFoundValue);
        /// <summary> QuotaMetricNotFound. </summary>
        public static DeviceRegistryOperationErrorCode QuotaMetricNotFound { get; } = new DeviceRegistryOperationErrorCode(QuotaMetricNotFoundValue);
        /// <summary> SystemPropertyNotFound. </summary>
        public static DeviceRegistryOperationErrorCode SystemPropertyNotFound { get; } = new DeviceRegistryOperationErrorCode(SystemPropertyNotFoundValue);
        /// <summary> AmqpAddressNotFound. </summary>
        public static DeviceRegistryOperationErrorCode AmqpAddressNotFound { get; } = new DeviceRegistryOperationErrorCode(AmqpAddressNotFoundValue);
        /// <summary> RoutingEndpointResponseNotFound. </summary>
        public static DeviceRegistryOperationErrorCode RoutingEndpointResponseNotFound { get; } = new DeviceRegistryOperationErrorCode(RoutingEndpointResponseNotFoundValue);
        /// <summary> CertificateNotFound. </summary>
        public static DeviceRegistryOperationErrorCode CertificateNotFound { get; } = new DeviceRegistryOperationErrorCode(CertificateNotFoundValue);
        /// <summary> ElasticPoolTenantHubNotFound. </summary>
        public static DeviceRegistryOperationErrorCode ElasticPoolTenantHubNotFound { get; } = new DeviceRegistryOperationErrorCode(ElasticPoolTenantHubNotFoundValue);
        /// <summary> ModuleNotFound. </summary>
        public static DeviceRegistryOperationErrorCode ModuleNotFound { get; } = new DeviceRegistryOperationErrorCode(ModuleNotFoundValue);
        /// <summary> AzureTableStoreNotFound. </summary>
        public static DeviceRegistryOperationErrorCode AzureTableStoreNotFound { get; } = new DeviceRegistryOperationErrorCode(AzureTableStoreNotFoundValue);
        /// <summary> IotHubFailingOver. </summary>
        public static DeviceRegistryOperationErrorCode IotHubFailingOver { get; } = new DeviceRegistryOperationErrorCode(IotHubFailingOverValue);
        /// <summary> FeatureNotSupported. </summary>
        public static DeviceRegistryOperationErrorCode FeatureNotSupported { get; } = new DeviceRegistryOperationErrorCode(FeatureNotSupportedValue);
        /// <summary> DigitalTwinInterfaceNotFound. </summary>
        public static DeviceRegistryOperationErrorCode DigitalTwinInterfaceNotFound { get; } = new DeviceRegistryOperationErrorCode(DigitalTwinInterfaceNotFoundValue);
        /// <summary> QueryStoreClusterNotFound. </summary>
        public static DeviceRegistryOperationErrorCode QueryStoreClusterNotFound { get; } = new DeviceRegistryOperationErrorCode(QueryStoreClusterNotFoundValue);
        /// <summary> DeviceNotOnline. </summary>
        public static DeviceRegistryOperationErrorCode DeviceNotOnline { get; } = new DeviceRegistryOperationErrorCode(DeviceNotOnlineValue);
        /// <summary> DeviceConnectionClosedRemotely. </summary>
        public static DeviceRegistryOperationErrorCode DeviceConnectionClosedRemotely { get; } = new DeviceRegistryOperationErrorCode(DeviceConnectionClosedRemotelyValue);
        /// <summary> EnrollmentNotFound. </summary>
        public static DeviceRegistryOperationErrorCode EnrollmentNotFound { get; } = new DeviceRegistryOperationErrorCode(EnrollmentNotFoundValue);
        /// <summary> DeviceRegistrationNotFound. </summary>
        public static DeviceRegistryOperationErrorCode DeviceRegistrationNotFound { get; } = new DeviceRegistryOperationErrorCode(DeviceRegistrationNotFoundValue);
        /// <summary> AsyncOperationNotFound. </summary>
        public static DeviceRegistryOperationErrorCode AsyncOperationNotFound { get; } = new DeviceRegistryOperationErrorCode(AsyncOperationNotFoundValue);
        /// <summary> EnrollmentGroupNotFound. </summary>
        public static DeviceRegistryOperationErrorCode EnrollmentGroupNotFound { get; } = new DeviceRegistryOperationErrorCode(EnrollmentGroupNotFoundValue);
        /// <summary> DeviceRecordNotFound. </summary>
        public static DeviceRegistryOperationErrorCode DeviceRecordNotFound { get; } = new DeviceRegistryOperationErrorCode(DeviceRecordNotFoundValue);
        /// <summary> GroupRecordNotFound. </summary>
        public static DeviceRegistryOperationErrorCode GroupRecordNotFound { get; } = new DeviceRegistryOperationErrorCode(GroupRecordNotFoundValue);
        /// <summary> DeviceGroupNotFound. </summary>
        public static DeviceRegistryOperationErrorCode DeviceGroupNotFound { get; } = new DeviceRegistryOperationErrorCode(DeviceGroupNotFoundValue);
        /// <summary> ProvisioningSettingsNotFound. </summary>
        public static DeviceRegistryOperationErrorCode ProvisioningSettingsNotFound { get; } = new DeviceRegistryOperationErrorCode(ProvisioningSettingsNotFoundValue);
        /// <summary> ProvisioningRecordNotFound. </summary>
        public static DeviceRegistryOperationErrorCode ProvisioningRecordNotFound { get; } = new DeviceRegistryOperationErrorCode(ProvisioningRecordNotFoundValue);
        /// <summary> LinkedHubNotFound. </summary>
        public static DeviceRegistryOperationErrorCode LinkedHubNotFound { get; } = new DeviceRegistryOperationErrorCode(LinkedHubNotFoundValue);
        /// <summary> CertificateAuthorityNotFound. </summary>
        public static DeviceRegistryOperationErrorCode CertificateAuthorityNotFound { get; } = new DeviceRegistryOperationErrorCode(CertificateAuthorityNotFoundValue);
        /// <summary> ConfigurationNotFound. </summary>
        public static DeviceRegistryOperationErrorCode ConfigurationNotFound { get; } = new DeviceRegistryOperationErrorCode(ConfigurationNotFoundValue);
        /// <summary> GroupNotFound. </summary>
        public static DeviceRegistryOperationErrorCode GroupNotFound { get; } = new DeviceRegistryOperationErrorCode(GroupNotFoundValue);
        /// <summary> DigitalTwinModelNotFound. </summary>
        public static DeviceRegistryOperationErrorCode DigitalTwinModelNotFound { get; } = new DeviceRegistryOperationErrorCode(DigitalTwinModelNotFoundValue);
        /// <summary> InterfaceNameModelNotFound. </summary>
        public static DeviceRegistryOperationErrorCode InterfaceNameModelNotFound { get; } = new DeviceRegistryOperationErrorCode(InterfaceNameModelNotFoundValue);
        /// <summary> GenericMethodNotAllowed. </summary>
        public static DeviceRegistryOperationErrorCode GenericMethodNotAllowed { get; } = new DeviceRegistryOperationErrorCode(GenericMethodNotAllowedValue);
        /// <summary> OperationNotAllowedInCurrentState. </summary>
        public static DeviceRegistryOperationErrorCode OperationNotAllowedInCurrentState { get; } = new DeviceRegistryOperationErrorCode(OperationNotAllowedInCurrentStateValue);
        /// <summary> ImportDevicesNotSupported. </summary>
        public static DeviceRegistryOperationErrorCode ImportDevicesNotSupported { get; } = new DeviceRegistryOperationErrorCode(ImportDevicesNotSupportedValue);
        /// <summary> BulkAddDevicesNotSupported. </summary>
        public static DeviceRegistryOperationErrorCode BulkAddDevicesNotSupported { get; } = new DeviceRegistryOperationErrorCode(BulkAddDevicesNotSupportedValue);
        /// <summary> GenericConflict. </summary>
        public static DeviceRegistryOperationErrorCode GenericConflict { get; } = new DeviceRegistryOperationErrorCode(GenericConflictValue);
        /// <summary> DeviceAlreadyExists. </summary>
        public static DeviceRegistryOperationErrorCode DeviceAlreadyExists { get; } = new DeviceRegistryOperationErrorCode(DeviceAlreadyExistsValue);
        /// <summary> LinkCreationConflict. </summary>
        public static DeviceRegistryOperationErrorCode LinkCreationConflict { get; } = new DeviceRegistryOperationErrorCode(LinkCreationConflictValue);
        /// <summary> CallbackSubscriptionConflict. </summary>
        public static DeviceRegistryOperationErrorCode CallbackSubscriptionConflict { get; } = new DeviceRegistryOperationErrorCode(CallbackSubscriptionConflictValue);
        /// <summary> ModelAlreadyExists. </summary>
        public static DeviceRegistryOperationErrorCode ModelAlreadyExists { get; } = new DeviceRegistryOperationErrorCode(ModelAlreadyExistsValue);
        /// <summary> DeviceLocked. </summary>
        public static DeviceRegistryOperationErrorCode DeviceLocked { get; } = new DeviceRegistryOperationErrorCode(DeviceLockedValue);
        /// <summary> DeviceJobAlreadyExists. </summary>
        public static DeviceRegistryOperationErrorCode DeviceJobAlreadyExists { get; } = new DeviceRegistryOperationErrorCode(DeviceJobAlreadyExistsValue);
        /// <summary> JobAlreadyExists. </summary>
        public static DeviceRegistryOperationErrorCode JobAlreadyExists { get; } = new DeviceRegistryOperationErrorCode(JobAlreadyExistsValue);
        /// <summary> EnrollmentConflict. </summary>
        public static DeviceRegistryOperationErrorCode EnrollmentConflict { get; } = new DeviceRegistryOperationErrorCode(EnrollmentConflictValue);
        /// <summary> EnrollmentGroupConflict. </summary>
        public static DeviceRegistryOperationErrorCode EnrollmentGroupConflict { get; } = new DeviceRegistryOperationErrorCode(EnrollmentGroupConflictValue);
        /// <summary> RegistrationStatusConflict. </summary>
        public static DeviceRegistryOperationErrorCode RegistrationStatusConflict { get; } = new DeviceRegistryOperationErrorCode(RegistrationStatusConflictValue);
        /// <summary> DeviceRecordConflict. </summary>
        public static DeviceRegistryOperationErrorCode DeviceRecordConflict { get; } = new DeviceRegistryOperationErrorCode(DeviceRecordConflictValue);
        /// <summary> GroupRecordConflict. </summary>
        public static DeviceRegistryOperationErrorCode GroupRecordConflict { get; } = new DeviceRegistryOperationErrorCode(GroupRecordConflictValue);
        /// <summary> DeviceGroupConflict. </summary>
        public static DeviceRegistryOperationErrorCode DeviceGroupConflict { get; } = new DeviceRegistryOperationErrorCode(DeviceGroupConflictValue);
        /// <summary> ProvisioningSettingsConflict. </summary>
        public static DeviceRegistryOperationErrorCode ProvisioningSettingsConflict { get; } = new DeviceRegistryOperationErrorCode(ProvisioningSettingsConflictValue);
        /// <summary> ProvisioningRecordConflict. </summary>
        public static DeviceRegistryOperationErrorCode ProvisioningRecordConflict { get; } = new DeviceRegistryOperationErrorCode(ProvisioningRecordConflictValue);
        /// <summary> LinkedHubConflict. </summary>
        public static DeviceRegistryOperationErrorCode LinkedHubConflict { get; } = new DeviceRegistryOperationErrorCode(LinkedHubConflictValue);
        /// <summary> CertificateAuthorityConflict. </summary>
        public static DeviceRegistryOperationErrorCode CertificateAuthorityConflict { get; } = new DeviceRegistryOperationErrorCode(CertificateAuthorityConflictValue);
        /// <summary> ModuleAlreadyExistsOnDevice. </summary>
        public static DeviceRegistryOperationErrorCode ModuleAlreadyExistsOnDevice { get; } = new DeviceRegistryOperationErrorCode(ModuleAlreadyExistsOnDeviceValue);
        /// <summary> ConfigurationAlreadyExists. </summary>
        public static DeviceRegistryOperationErrorCode ConfigurationAlreadyExists { get; } = new DeviceRegistryOperationErrorCode(ConfigurationAlreadyExistsValue);
        /// <summary> ApplyConfigurationAlreadyInProgressOnDevice. </summary>
        public static DeviceRegistryOperationErrorCode ApplyConfigurationAlreadyInProgressOnDevice { get; } = new DeviceRegistryOperationErrorCode(ApplyConfigurationAlreadyInProgressOnDeviceValue);
        /// <summary> DigitalTwinModelAlreadyExists. </summary>
        public static DeviceRegistryOperationErrorCode DigitalTwinModelAlreadyExists { get; } = new DeviceRegistryOperationErrorCode(DigitalTwinModelAlreadyExistsValue);
        /// <summary> DigitalTwinModelExistsWithOtherModelType. </summary>
        public static DeviceRegistryOperationErrorCode DigitalTwinModelExistsWithOtherModelType { get; } = new DeviceRegistryOperationErrorCode(DigitalTwinModelExistsWithOtherModelTypeValue);
        /// <summary> InterfaceNameModelAlreadyExists. </summary>
        public static DeviceRegistryOperationErrorCode InterfaceNameModelAlreadyExists { get; } = new DeviceRegistryOperationErrorCode(InterfaceNameModelAlreadyExistsValue);
        /// <summary> GenericPreconditionFailed. </summary>
        public static DeviceRegistryOperationErrorCode GenericPreconditionFailed { get; } = new DeviceRegistryOperationErrorCode(GenericPreconditionFailedValue);
        /// <summary> PreconditionFailed. </summary>
        public static DeviceRegistryOperationErrorCode PreconditionFailed { get; } = new DeviceRegistryOperationErrorCode(PreconditionFailedValue);
        /// <summary> DeviceMessageLockLost. </summary>
        public static DeviceRegistryOperationErrorCode DeviceMessageLockLost { get; } = new DeviceRegistryOperationErrorCode(DeviceMessageLockLostValue);
        /// <summary> JobRunPreconditionFailed. </summary>
        public static DeviceRegistryOperationErrorCode JobRunPreconditionFailed { get; } = new DeviceRegistryOperationErrorCode(JobRunPreconditionFailedValue);
        /// <summary> InflightMessagesInLink. </summary>
        public static DeviceRegistryOperationErrorCode InflightMessagesInLink { get; } = new DeviceRegistryOperationErrorCode(InflightMessagesInLinkValue);
        /// <summary> GenericRequestEntityTooLarge. </summary>
        public static DeviceRegistryOperationErrorCode GenericRequestEntityTooLarge { get; } = new DeviceRegistryOperationErrorCode(GenericRequestEntityTooLargeValue);
        /// <summary> MessageTooLarge. </summary>
        public static DeviceRegistryOperationErrorCode MessageTooLarge { get; } = new DeviceRegistryOperationErrorCode(MessageTooLargeValue);
        /// <summary> TooManyDevices. </summary>
        public static DeviceRegistryOperationErrorCode TooManyDevices { get; } = new DeviceRegistryOperationErrorCode(TooManyDevicesValue);
        /// <summary> TooManyModulesOnDevice. </summary>
        public static DeviceRegistryOperationErrorCode TooManyModulesOnDevice { get; } = new DeviceRegistryOperationErrorCode(TooManyModulesOnDeviceValue);
        /// <summary> ConfigurationCountLimitExceeded. </summary>
        public static DeviceRegistryOperationErrorCode ConfigurationCountLimitExceeded { get; } = new DeviceRegistryOperationErrorCode(ConfigurationCountLimitExceededValue);
        /// <summary> DigitalTwinModelCountLimitExceeded. </summary>
        public static DeviceRegistryOperationErrorCode DigitalTwinModelCountLimitExceeded { get; } = new DeviceRegistryOperationErrorCode(DigitalTwinModelCountLimitExceededValue);
        /// <summary> InterfaceNameCompressionModelCountLimitExceeded. </summary>
        public static DeviceRegistryOperationErrorCode InterfaceNameCompressionModelCountLimitExceeded { get; } = new DeviceRegistryOperationErrorCode(InterfaceNameCompressionModelCountLimitExceededValue);
        /// <summary> GenericUnsupportedMediaType. </summary>
        public static DeviceRegistryOperationErrorCode GenericUnsupportedMediaType { get; } = new DeviceRegistryOperationErrorCode(GenericUnsupportedMediaTypeValue);
        /// <summary> IncompatibleDataType. </summary>
        public static DeviceRegistryOperationErrorCode IncompatibleDataType { get; } = new DeviceRegistryOperationErrorCode(IncompatibleDataTypeValue);
        /// <summary> GenericTooManyRequests. </summary>
        public static DeviceRegistryOperationErrorCode GenericTooManyRequests { get; } = new DeviceRegistryOperationErrorCode(GenericTooManyRequestsValue);
        /// <summary> ThrottlingException. </summary>
        public static DeviceRegistryOperationErrorCode ThrottlingException { get; } = new DeviceRegistryOperationErrorCode(ThrottlingExceptionValue);
        /// <summary> ThrottleBacklogLimitExceeded. </summary>
        public static DeviceRegistryOperationErrorCode ThrottleBacklogLimitExceeded { get; } = new DeviceRegistryOperationErrorCode(ThrottleBacklogLimitExceededValue);
        /// <summary> ThrottlingBacklogTimeout. </summary>
        public static DeviceRegistryOperationErrorCode ThrottlingBacklogTimeout { get; } = new DeviceRegistryOperationErrorCode(ThrottlingBacklogTimeoutValue);
        /// <summary> ThrottlingMaxActiveJobCountExceeded. </summary>
        public static DeviceRegistryOperationErrorCode ThrottlingMaxActiveJobCountExceeded { get; } = new DeviceRegistryOperationErrorCode(ThrottlingMaxActiveJobCountExceededValue);
        /// <summary> DeviceThrottlingLimitExceeded. </summary>
        public static DeviceRegistryOperationErrorCode DeviceThrottlingLimitExceeded { get; } = new DeviceRegistryOperationErrorCode(DeviceThrottlingLimitExceededValue);
        /// <summary> ClientClosedRequest. </summary>
        public static DeviceRegistryOperationErrorCode ClientClosedRequest { get; } = new DeviceRegistryOperationErrorCode(ClientClosedRequestValue);
        /// <summary> GenericServerError. </summary>
        public static DeviceRegistryOperationErrorCode GenericServerError { get; } = new DeviceRegistryOperationErrorCode(GenericServerErrorValue);
        /// <summary> ServerError. </summary>
        public static DeviceRegistryOperationErrorCode ServerError { get; } = new DeviceRegistryOperationErrorCode(ServerErrorValue);
        /// <summary> JobCancelled. </summary>
        public static DeviceRegistryOperationErrorCode JobCancelled { get; } = new DeviceRegistryOperationErrorCode(JobCancelledValue);
        /// <summary> StatisticsRetrievalError. </summary>
        public static DeviceRegistryOperationErrorCode StatisticsRetrievalError { get; } = new DeviceRegistryOperationErrorCode(StatisticsRetrievalErrorValue);
        /// <summary> ConnectionForcefullyClosed. </summary>
        public static DeviceRegistryOperationErrorCode ConnectionForcefullyClosed { get; } = new DeviceRegistryOperationErrorCode(ConnectionForcefullyClosedValue);
        /// <summary> InvalidBlobState. </summary>
        public static DeviceRegistryOperationErrorCode InvalidBlobState { get; } = new DeviceRegistryOperationErrorCode(InvalidBlobStateValue);
        /// <summary> BackupTimedOut. </summary>
        public static DeviceRegistryOperationErrorCode BackupTimedOut { get; } = new DeviceRegistryOperationErrorCode(BackupTimedOutValue);
        /// <summary> AzureStorageTimeout. </summary>
        public static DeviceRegistryOperationErrorCode AzureStorageTimeout { get; } = new DeviceRegistryOperationErrorCode(AzureStorageTimeoutValue);
        /// <summary> GenericTimeout. </summary>
        public static DeviceRegistryOperationErrorCode GenericTimeout { get; } = new DeviceRegistryOperationErrorCode(GenericTimeoutValue);
        /// <summary> InvalidThrottleParameter. </summary>
        public static DeviceRegistryOperationErrorCode InvalidThrottleParameter { get; } = new DeviceRegistryOperationErrorCode(InvalidThrottleParameterValue);
        /// <summary> EventHubLinkAlreadyClosed. </summary>
        public static DeviceRegistryOperationErrorCode EventHubLinkAlreadyClosed { get; } = new DeviceRegistryOperationErrorCode(EventHubLinkAlreadyClosedValue);
        /// <summary> ReliableBlobStoreError. </summary>
        public static DeviceRegistryOperationErrorCode ReliableBlobStoreError { get; } = new DeviceRegistryOperationErrorCode(ReliableBlobStoreErrorValue);
        /// <summary> RetryAttemptsExhausted. </summary>
        public static DeviceRegistryOperationErrorCode RetryAttemptsExhausted { get; } = new DeviceRegistryOperationErrorCode(RetryAttemptsExhaustedValue);
        /// <summary> AzureTableStoreError. </summary>
        public static DeviceRegistryOperationErrorCode AzureTableStoreError { get; } = new DeviceRegistryOperationErrorCode(AzureTableStoreErrorValue);
        /// <summary> CheckpointStoreNotFound. </summary>
        public static DeviceRegistryOperationErrorCode CheckpointStoreNotFound { get; } = new DeviceRegistryOperationErrorCode(CheckpointStoreNotFoundValue);
        /// <summary> DocumentDbInvalidReturnValue. </summary>
        public static DeviceRegistryOperationErrorCode DocumentDbInvalidReturnValue { get; } = new DeviceRegistryOperationErrorCode(DocumentDbInvalidReturnValueValue);
        /// <summary> ReliableDocDbStoreStoreError. </summary>
        public static DeviceRegistryOperationErrorCode ReliableDocDbStoreStoreError { get; } = new DeviceRegistryOperationErrorCode(ReliableDocDbStoreStoreErrorValue);
        /// <summary> ReliableBlobStoreTimeoutError. </summary>
        public static DeviceRegistryOperationErrorCode ReliableBlobStoreTimeoutError { get; } = new DeviceRegistryOperationErrorCode(ReliableBlobStoreTimeoutErrorValue);
        /// <summary> ConfigReadFailed. </summary>
        public static DeviceRegistryOperationErrorCode ConfigReadFailed { get; } = new DeviceRegistryOperationErrorCode(ConfigReadFailedValue);
        /// <summary> InvalidContainerReceiveLink. </summary>
        public static DeviceRegistryOperationErrorCode InvalidContainerReceiveLink { get; } = new DeviceRegistryOperationErrorCode(InvalidContainerReceiveLinkValue);
        /// <summary> InvalidPartitionEpoch. </summary>
        public static DeviceRegistryOperationErrorCode InvalidPartitionEpoch { get; } = new DeviceRegistryOperationErrorCode(InvalidPartitionEpochValue);
        /// <summary> RestoreTimedOut. </summary>
        public static DeviceRegistryOperationErrorCode RestoreTimedOut { get; } = new DeviceRegistryOperationErrorCode(RestoreTimedOutValue);
        /// <summary> StreamReservationFailure. </summary>
        public static DeviceRegistryOperationErrorCode StreamReservationFailure { get; } = new DeviceRegistryOperationErrorCode(StreamReservationFailureValue);
        /// <summary> SerializationError. </summary>
        public static DeviceRegistryOperationErrorCode SerializationError { get; } = new DeviceRegistryOperationErrorCode(SerializationErrorValue);
        /// <summary> UnexpectedPropertyValue. </summary>
        public static DeviceRegistryOperationErrorCode UnexpectedPropertyValue { get; } = new DeviceRegistryOperationErrorCode(UnexpectedPropertyValueValue);
        /// <summary> OrchestrationOperationFailed. </summary>
        public static DeviceRegistryOperationErrorCode OrchestrationOperationFailed { get; } = new DeviceRegistryOperationErrorCode(OrchestrationOperationFailedValue);
        /// <summary> ModelRepoEndpointError. </summary>
        public static DeviceRegistryOperationErrorCode ModelRepoEndpointError { get; } = new DeviceRegistryOperationErrorCode(ModelRepoEndpointErrorValue);
        /// <summary> ResolutionError. </summary>
        public static DeviceRegistryOperationErrorCode ResolutionError { get; } = new DeviceRegistryOperationErrorCode(ResolutionErrorValue);
        /// <summary> UnableToFetchCredentials. </summary>
        public static DeviceRegistryOperationErrorCode UnableToFetchCredentials { get; } = new DeviceRegistryOperationErrorCode(UnableToFetchCredentialsValue);
        /// <summary> UnableToFetchTenantInfo. </summary>
        public static DeviceRegistryOperationErrorCode UnableToFetchTenantInfo { get; } = new DeviceRegistryOperationErrorCode(UnableToFetchTenantInfoValue);
        /// <summary> UnableToShareIdentity. </summary>
        public static DeviceRegistryOperationErrorCode UnableToShareIdentity { get; } = new DeviceRegistryOperationErrorCode(UnableToShareIdentityValue);
        /// <summary> UnableToExpandDiscoveryInfo. </summary>
        public static DeviceRegistryOperationErrorCode UnableToExpandDiscoveryInfo { get; } = new DeviceRegistryOperationErrorCode(UnableToExpandDiscoveryInfoValue);
        /// <summary> UnableToExpandComponentInfo. </summary>
        public static DeviceRegistryOperationErrorCode UnableToExpandComponentInfo { get; } = new DeviceRegistryOperationErrorCode(UnableToExpandComponentInfoValue);
        /// <summary> UnableToCompressComponentInfo. </summary>
        public static DeviceRegistryOperationErrorCode UnableToCompressComponentInfo { get; } = new DeviceRegistryOperationErrorCode(UnableToCompressComponentInfoValue);
        /// <summary> UnableToCompressDiscoveryInfo. </summary>
        public static DeviceRegistryOperationErrorCode UnableToCompressDiscoveryInfo { get; } = new DeviceRegistryOperationErrorCode(UnableToCompressDiscoveryInfoValue);
        /// <summary> OrphanDiscoveryDocument. </summary>
        public static DeviceRegistryOperationErrorCode OrphanDiscoveryDocument { get; } = new DeviceRegistryOperationErrorCode(OrphanDiscoveryDocumentValue);
        /// <summary> GenericBadGateway. </summary>
        public static DeviceRegistryOperationErrorCode GenericBadGateway { get; } = new DeviceRegistryOperationErrorCode(GenericBadGatewayValue);
        /// <summary> InvalidResponseWhileProxying. </summary>
        public static DeviceRegistryOperationErrorCode InvalidResponseWhileProxying { get; } = new DeviceRegistryOperationErrorCode(InvalidResponseWhileProxyingValue);
        /// <summary> GenericServiceUnavailable. </summary>
        public static DeviceRegistryOperationErrorCode GenericServiceUnavailable { get; } = new DeviceRegistryOperationErrorCode(GenericServiceUnavailableValue);
        /// <summary> ServiceUnavailable. </summary>
        public static DeviceRegistryOperationErrorCode ServiceUnavailable { get; } = new DeviceRegistryOperationErrorCode(ServiceUnavailableValue);
        /// <summary> PartitionNotFound. </summary>
        public static DeviceRegistryOperationErrorCode PartitionNotFound { get; } = new DeviceRegistryOperationErrorCode(PartitionNotFoundValue);
        /// <summary> IotHubActivationFailed. </summary>
        public static DeviceRegistryOperationErrorCode IotHubActivationFailed { get; } = new DeviceRegistryOperationErrorCode(IotHubActivationFailedValue);
        /// <summary> ServerBusy. </summary>
        public static DeviceRegistryOperationErrorCode ServerBusy { get; } = new DeviceRegistryOperationErrorCode(ServerBusyValue);
        /// <summary> IotHubRestoring. </summary>
        public static DeviceRegistryOperationErrorCode IotHubRestoring { get; } = new DeviceRegistryOperationErrorCode(IotHubRestoringValue);
        /// <summary> ReceiveLinkOpensThrottled. </summary>
        public static DeviceRegistryOperationErrorCode ReceiveLinkOpensThrottled { get; } = new DeviceRegistryOperationErrorCode(ReceiveLinkOpensThrottledValue);
        /// <summary> ConnectionUnavailable. </summary>
        public static DeviceRegistryOperationErrorCode ConnectionUnavailable { get; } = new DeviceRegistryOperationErrorCode(ConnectionUnavailableValue);
        /// <summary> DeviceUnavailable. </summary>
        public static DeviceRegistryOperationErrorCode DeviceUnavailable { get; } = new DeviceRegistryOperationErrorCode(DeviceUnavailableValue);
        /// <summary> ConfigurationNotAvailable. </summary>
        public static DeviceRegistryOperationErrorCode ConfigurationNotAvailable { get; } = new DeviceRegistryOperationErrorCode(ConfigurationNotAvailableValue);
        /// <summary> GroupNotAvailable. </summary>
        public static DeviceRegistryOperationErrorCode GroupNotAvailable { get; } = new DeviceRegistryOperationErrorCode(GroupNotAvailableValue);
        /// <summary> HostingServiceNotAvailable. </summary>
        public static DeviceRegistryOperationErrorCode HostingServiceNotAvailable { get; } = new DeviceRegistryOperationErrorCode(HostingServiceNotAvailableValue);
        /// <summary> GenericGatewayTimeout. </summary>
        public static DeviceRegistryOperationErrorCode GenericGatewayTimeout { get; } = new DeviceRegistryOperationErrorCode(GenericGatewayTimeoutValue);
        /// <summary> GatewayTimeout. </summary>
        public static DeviceRegistryOperationErrorCode GatewayTimeout { get; } = new DeviceRegistryOperationErrorCode(GatewayTimeoutValue);
        /// <summary> Determines if two <see cref="DeviceRegistryOperationErrorCode"/> values are the same. </summary>
        public static bool operator ==(DeviceRegistryOperationErrorCode left, DeviceRegistryOperationErrorCode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DeviceRegistryOperationErrorCode"/> values are not the same. </summary>
        public static bool operator !=(DeviceRegistryOperationErrorCode left, DeviceRegistryOperationErrorCode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DeviceRegistryOperationErrorCode"/>. </summary>
        public static implicit operator DeviceRegistryOperationErrorCode(string value) => new DeviceRegistryOperationErrorCode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DeviceRegistryOperationErrorCode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DeviceRegistryOperationErrorCode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
