// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.IoT.Hub.Service.Models
{
    public partial class DeviceRegistryOperationError
    {
        internal static DeviceRegistryOperationError DeserializeDeviceRegistryOperationError(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string deviceId = default;
            DeviceRegistryOperationErrorCode? errorCode = default;
            string errorStatus = default;
            string moduleId = default;
            string operation = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("deviceId"u8))
                {
                    deviceId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("errorCode"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    errorCode = new DeviceRegistryOperationErrorCode(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("errorStatus"u8))
                {
                    errorStatus = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("moduleId"u8))
                {
                    moduleId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("operation"u8))
                {
                    operation = property.Value.GetString();
                    continue;
                }
            }
            return new DeviceRegistryOperationError(deviceId, errorCode, errorStatus, moduleId, operation);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static DeviceRegistryOperationError FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeDeviceRegistryOperationError(document.RootElement);
        }
    }
}
