// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.IoT.Hub.Service.Models
{
    /// <summary> The job statistics regarding execution status. </summary>
    public partial class DeviceJobStatistics
    {
        /// <summary> Initializes a new instance of <see cref="DeviceJobStatistics"/>. </summary>
        internal DeviceJobStatistics()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DeviceJobStatistics"/>. </summary>
        /// <param name="deviceCount"> The number of devices targeted by the job. </param>
        /// <param name="failedCount"> The number of failed jobs. </param>
        /// <param name="succeededCount"> The number of succeeded jobs. </param>
        /// <param name="runningCount"> The number of running jobs. </param>
        /// <param name="pendingCount"> The number of pending (scheduled) jobs. </param>
        internal DeviceJobStatistics(int? deviceCount, int? failedCount, int? succeededCount, int? runningCount, int? pendingCount)
        {
            DeviceCount = deviceCount;
            FailedCount = failedCount;
            SucceededCount = succeededCount;
            RunningCount = runningCount;
            PendingCount = pendingCount;
        }

        /// <summary> The number of devices targeted by the job. </summary>
        public int? DeviceCount { get; }
        /// <summary> The number of failed jobs. </summary>
        public int? FailedCount { get; }
        /// <summary> The number of succeeded jobs. </summary>
        public int? SucceededCount { get; }
        /// <summary> The number of running jobs. </summary>
        public int? RunningCount { get; }
        /// <summary> The number of pending (scheduled) jobs. </summary>
        public int? PendingCount { get; }
    }
}
