// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;

namespace Azure.IoT.Hub.Service.Models
{
    public partial class ConfigurationQueriesTestResponse
    {
        internal static ConfigurationQueriesTestResponse DeserializeConfigurationQueriesTestResponse(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string targetConditionError = default;
            IReadOnlyDictionary<string, string> customMetricQueryErrors = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("targetConditionError"u8))
                {
                    targetConditionError = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("customMetricQueryErrors"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, string> dictionary = new Dictionary<string, string>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, property0.Value.GetString());
                    }
                    customMetricQueryErrors = dictionary;
                    continue;
                }
            }
            return new ConfigurationQueriesTestResponse(targetConditionError, customMetricQueryErrors ?? new ChangeTrackingDictionary<string, string>());
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static ConfigurationQueriesTestResponse FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeConfigurationQueriesTestResponse(document.RootElement);
        }
    }
}
