// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.IoT.Hub.Service.Models
{
    /// <summary> The configuration metrics for Iot Hub devices and modules. </summary>
    public partial class ConfigurationMetrics
    {
        /// <summary> Initializes a new instance of <see cref="ConfigurationMetrics"/>. </summary>
        public ConfigurationMetrics()
        {
            Results = new ChangeTrackingDictionary<string, long>();
            Queries = new ChangeTrackingDictionary<string, string>();
        }

        /// <summary> Initializes a new instance of <see cref="ConfigurationMetrics"/>. </summary>
        /// <param name="results"> The results of the metrics collection queries. </param>
        /// <param name="queries"> The key-value pairs with queries and their identifier. </param>
        internal ConfigurationMetrics(IDictionary<string, long> results, IDictionary<string, string> queries)
        {
            Results = results;
            Queries = queries;
        }

        /// <summary> The results of the metrics collection queries. </summary>
        public IDictionary<string, long> Results { get; }
        /// <summary> The key-value pairs with queries and their identifier. </summary>
        public IDictionary<string, string> Queries { get; }
    }
}
