// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.IoT.Hub.Service.Models
{
    /// <summary> The configuration content for devices or modules on edge devices. </summary>
    public partial class ConfigurationContent
    {
        /// <summary> Initializes a new instance of <see cref="ConfigurationContent"/>. </summary>
        public ConfigurationContent()
        {
            DeviceContent = new ChangeTrackingDictionary<string, object>();
            ModulesContent = new ChangeTrackingDictionary<string, IDictionary<string, object>>();
            ModuleContent = new ChangeTrackingDictionary<string, object>();
        }

        /// <summary> Initializes a new instance of <see cref="ConfigurationContent"/>. </summary>
        /// <param name="deviceContent"> The device configuration content. </param>
        /// <param name="modulesContent"> The modules configuration content. </param>
        /// <param name="moduleContent"> The module configuration content. </param>
        internal ConfigurationContent(IDictionary<string, object> deviceContent, IDictionary<string, IDictionary<string, object>> modulesContent, IDictionary<string, object> moduleContent)
        {
            DeviceContent = deviceContent;
            ModulesContent = modulesContent;
            ModuleContent = moduleContent;
        }

        /// <summary> The device configuration content. </summary>
        public IDictionary<string, object> DeviceContent { get; }
        /// <summary> The modules configuration content. </summary>
        public IDictionary<string, IDictionary<string, object>> ModulesContent { get; }
        /// <summary> The module configuration content. </summary>
        public IDictionary<string, object> ModuleContent { get; }
    }
}
