// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.IoT.Hub.Service.Models
{
    /// <summary> The result of the bulk registry operation. </summary>
    public partial class BulkRegistryOperationResponse
    {
        /// <summary> Initializes a new instance of <see cref="BulkRegistryOperationResponse"/>. </summary>
        internal BulkRegistryOperationResponse()
        {
            Errors = new ChangeTrackingList<DeviceRegistryOperationError>();
            Warnings = new ChangeTrackingList<DeviceRegistryOperationWarning>();
        }

        /// <summary> Initializes a new instance of <see cref="BulkRegistryOperationResponse"/>. </summary>
        /// <param name="isSuccessful"> The operation result. </param>
        /// <param name="errors"> The device registry operation errors. </param>
        /// <param name="warnings"> The device registry operation warnings. </param>
        internal BulkRegistryOperationResponse(bool? isSuccessful, IReadOnlyList<DeviceRegistryOperationError> errors, IReadOnlyList<DeviceRegistryOperationWarning> warnings)
        {
            IsSuccessful = isSuccessful;
            Errors = errors;
            Warnings = warnings;
        }

        /// <summary> The operation result. </summary>
        public bool? IsSuccessful { get; }
        /// <summary> The device registry operation errors. </summary>
        public IReadOnlyList<DeviceRegistryOperationError> Errors { get; }
        /// <summary> The device registry operation warnings. </summary>
        public IReadOnlyList<DeviceRegistryOperationWarning> Warnings { get; }
    }
}
