// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.IoT.Hub.Service.Models
{
    /// <summary> The AuthenticationMechanism. </summary>
    public partial class AuthenticationMechanism
    {
        /// <summary> Initializes a new instance of <see cref="AuthenticationMechanism"/>. </summary>
        public AuthenticationMechanism()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AuthenticationMechanism"/>. </summary>
        /// <param name="symmetricKey"> The primary and secondary keys used for SAS based authentication. </param>
        /// <param name="x509Thumbprint"> The primary and secondary x509 thumbprints used for x509 based authentication. </param>
        /// <param name="type"> The type of authentication used to connect to the service. </param>
        internal AuthenticationMechanism(SymmetricKey symmetricKey, X509Thumbprint x509Thumbprint, AuthenticationMechanismType? type)
        {
            SymmetricKey = symmetricKey;
            X509Thumbprint = x509Thumbprint;
            Type = type;
        }

        /// <summary> The primary and secondary keys used for SAS based authentication. </summary>
        public SymmetricKey SymmetricKey { get; set; }
        /// <summary> The primary and secondary x509 thumbprints used for x509 based authentication. </summary>
        public X509Thumbprint X509Thumbprint { get; set; }
        /// <summary> The type of authentication used to connect to the service. </summary>
        public AuthenticationMechanismType? Type { get; set; }
    }
}
