// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.InformaticaDataManagement.Models;

namespace Azure.ResourceManager.InformaticaDataManagement
{
    internal partial class ServerlessRuntimesRestOperations
    {
        private readonly TelemetryDetails _userAgent;
        private readonly HttpPipeline _pipeline;
        private readonly Uri _endpoint;
        private readonly string _apiVersion;

        /// <summary> Initializes a new instance of ServerlessRuntimesRestOperations. </summary>
        /// <param name="pipeline"> The HTTP pipeline for sending and receiving REST requests and responses. </param>
        /// <param name="applicationId"> The application id to use for user agent. </param>
        /// <param name="endpoint"> Service host. </param>
        /// <param name="apiVersion"> The API version to use for this operation. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="pipeline"/> or <paramref name="apiVersion"/> is null. </exception>
        public ServerlessRuntimesRestOperations(HttpPipeline pipeline, string applicationId, Uri endpoint = null, string apiVersion = default)
        {
            _pipeline = pipeline ?? throw new ArgumentNullException(nameof(pipeline));
            _endpoint = endpoint ?? new Uri("https://management.azure.com");
            _apiVersion = apiVersion ?? "2024-05-08";
            _userAgent = new TelemetryDetails(GetType().Assembly, applicationId);
        }

        internal RequestUriBuilder CreateGetRequestUri(string subscriptionId, string resourceGroupName, string organizationName, string serverlessRuntimeName)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Informatica.DataManagement/organizations/", false);
            uri.AppendPath(organizationName, true);
            uri.AppendPath("/serverlessRuntimes/", false);
            uri.AppendPath(serverlessRuntimeName, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateGetRequest(string subscriptionId, string resourceGroupName, string organizationName, string serverlessRuntimeName)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Informatica.DataManagement/organizations/", false);
            uri.AppendPath(organizationName, true);
            uri.AppendPath("/serverlessRuntimes/", false);
            uri.AppendPath(serverlessRuntimeName, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Get a InformaticaServerlessRuntimeResource. </summary>
        /// <param name="subscriptionId"> The ID of the target subscription. The value must be an UUID. </param>
        /// <param name="resourceGroupName"> The name of the resource group. The name is case insensitive. </param>
        /// <param name="organizationName"> Name of the Organizations resource. </param>
        /// <param name="serverlessRuntimeName"> Name of the Serverless Runtime resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="organizationName"/> or <paramref name="serverlessRuntimeName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="organizationName"/> or <paramref name="serverlessRuntimeName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<InformaticaServerlessRuntimeData>> GetAsync(string subscriptionId, string resourceGroupName, string organizationName, string serverlessRuntimeName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(organizationName, nameof(organizationName));
            Argument.AssertNotNullOrEmpty(serverlessRuntimeName, nameof(serverlessRuntimeName));

            using var message = CreateGetRequest(subscriptionId, resourceGroupName, organizationName, serverlessRuntimeName);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        InformaticaServerlessRuntimeData value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = InformaticaServerlessRuntimeData.DeserializeInformaticaServerlessRuntimeData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                case 404:
                    return Response.FromValue((InformaticaServerlessRuntimeData)null, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Get a InformaticaServerlessRuntimeResource. </summary>
        /// <param name="subscriptionId"> The ID of the target subscription. The value must be an UUID. </param>
        /// <param name="resourceGroupName"> The name of the resource group. The name is case insensitive. </param>
        /// <param name="organizationName"> Name of the Organizations resource. </param>
        /// <param name="serverlessRuntimeName"> Name of the Serverless Runtime resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="organizationName"/> or <paramref name="serverlessRuntimeName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="organizationName"/> or <paramref name="serverlessRuntimeName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<InformaticaServerlessRuntimeData> Get(string subscriptionId, string resourceGroupName, string organizationName, string serverlessRuntimeName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(organizationName, nameof(organizationName));
            Argument.AssertNotNullOrEmpty(serverlessRuntimeName, nameof(serverlessRuntimeName));

            using var message = CreateGetRequest(subscriptionId, resourceGroupName, organizationName, serverlessRuntimeName);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        InformaticaServerlessRuntimeData value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = InformaticaServerlessRuntimeData.DeserializeInformaticaServerlessRuntimeData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                case 404:
                    return Response.FromValue((InformaticaServerlessRuntimeData)null, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateCreateOrUpdateRequestUri(string subscriptionId, string resourceGroupName, string organizationName, string serverlessRuntimeName, InformaticaServerlessRuntimeData data)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Informatica.DataManagement/organizations/", false);
            uri.AppendPath(organizationName, true);
            uri.AppendPath("/serverlessRuntimes/", false);
            uri.AppendPath(serverlessRuntimeName, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateCreateOrUpdateRequest(string subscriptionId, string resourceGroupName, string organizationName, string serverlessRuntimeName, InformaticaServerlessRuntimeData data)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Put;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Informatica.DataManagement/organizations/", false);
            uri.AppendPath(organizationName, true);
            uri.AppendPath("/serverlessRuntimes/", false);
            uri.AppendPath(serverlessRuntimeName, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(data, ModelSerializationExtensions.WireOptions);
            request.Content = content;
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Create a InformaticaServerlessRuntimeResource. </summary>
        /// <param name="subscriptionId"> The ID of the target subscription. The value must be an UUID. </param>
        /// <param name="resourceGroupName"> The name of the resource group. The name is case insensitive. </param>
        /// <param name="organizationName"> Name of the Organizations resource. </param>
        /// <param name="serverlessRuntimeName"> Name of the Serverless Runtime resource. </param>
        /// <param name="data"> Resource create parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="organizationName"/>, <paramref name="serverlessRuntimeName"/> or <paramref name="data"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="organizationName"/> or <paramref name="serverlessRuntimeName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response> CreateOrUpdateAsync(string subscriptionId, string resourceGroupName, string organizationName, string serverlessRuntimeName, InformaticaServerlessRuntimeData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(organizationName, nameof(organizationName));
            Argument.AssertNotNullOrEmpty(serverlessRuntimeName, nameof(serverlessRuntimeName));
            Argument.AssertNotNull(data, nameof(data));

            using var message = CreateCreateOrUpdateRequest(subscriptionId, resourceGroupName, organizationName, serverlessRuntimeName, data);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                case 201:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Create a InformaticaServerlessRuntimeResource. </summary>
        /// <param name="subscriptionId"> The ID of the target subscription. The value must be an UUID. </param>
        /// <param name="resourceGroupName"> The name of the resource group. The name is case insensitive. </param>
        /// <param name="organizationName"> Name of the Organizations resource. </param>
        /// <param name="serverlessRuntimeName"> Name of the Serverless Runtime resource. </param>
        /// <param name="data"> Resource create parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="organizationName"/>, <paramref name="serverlessRuntimeName"/> or <paramref name="data"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="organizationName"/> or <paramref name="serverlessRuntimeName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response CreateOrUpdate(string subscriptionId, string resourceGroupName, string organizationName, string serverlessRuntimeName, InformaticaServerlessRuntimeData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(organizationName, nameof(organizationName));
            Argument.AssertNotNullOrEmpty(serverlessRuntimeName, nameof(serverlessRuntimeName));
            Argument.AssertNotNull(data, nameof(data));

            using var message = CreateCreateOrUpdateRequest(subscriptionId, resourceGroupName, organizationName, serverlessRuntimeName, data);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                case 201:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateDeleteRequestUri(string subscriptionId, string resourceGroupName, string organizationName, string serverlessRuntimeName)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Informatica.DataManagement/organizations/", false);
            uri.AppendPath(organizationName, true);
            uri.AppendPath("/serverlessRuntimes/", false);
            uri.AppendPath(serverlessRuntimeName, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateDeleteRequest(string subscriptionId, string resourceGroupName, string organizationName, string serverlessRuntimeName)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Delete;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Informatica.DataManagement/organizations/", false);
            uri.AppendPath(organizationName, true);
            uri.AppendPath("/serverlessRuntimes/", false);
            uri.AppendPath(serverlessRuntimeName, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Delete a InformaticaServerlessRuntimeResource. </summary>
        /// <param name="subscriptionId"> The ID of the target subscription. The value must be an UUID. </param>
        /// <param name="resourceGroupName"> The name of the resource group. The name is case insensitive. </param>
        /// <param name="organizationName"> Name of the Organizations resource. </param>
        /// <param name="serverlessRuntimeName"> Name of the Serverless Runtime resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="organizationName"/> or <paramref name="serverlessRuntimeName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="organizationName"/> or <paramref name="serverlessRuntimeName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response> DeleteAsync(string subscriptionId, string resourceGroupName, string organizationName, string serverlessRuntimeName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(organizationName, nameof(organizationName));
            Argument.AssertNotNullOrEmpty(serverlessRuntimeName, nameof(serverlessRuntimeName));

            using var message = CreateDeleteRequest(subscriptionId, resourceGroupName, organizationName, serverlessRuntimeName);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 202:
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Delete a InformaticaServerlessRuntimeResource. </summary>
        /// <param name="subscriptionId"> The ID of the target subscription. The value must be an UUID. </param>
        /// <param name="resourceGroupName"> The name of the resource group. The name is case insensitive. </param>
        /// <param name="organizationName"> Name of the Organizations resource. </param>
        /// <param name="serverlessRuntimeName"> Name of the Serverless Runtime resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="organizationName"/> or <paramref name="serverlessRuntimeName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="organizationName"/> or <paramref name="serverlessRuntimeName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response Delete(string subscriptionId, string resourceGroupName, string organizationName, string serverlessRuntimeName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(organizationName, nameof(organizationName));
            Argument.AssertNotNullOrEmpty(serverlessRuntimeName, nameof(serverlessRuntimeName));

            using var message = CreateDeleteRequest(subscriptionId, resourceGroupName, organizationName, serverlessRuntimeName);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 202:
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateListByInformaticaOrganizationResourceRequestUri(string subscriptionId, string resourceGroupName, string organizationName)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Informatica.DataManagement/organizations/", false);
            uri.AppendPath(organizationName, true);
            uri.AppendPath("/serverlessRuntimes", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateListByInformaticaOrganizationResourceRequest(string subscriptionId, string resourceGroupName, string organizationName)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Informatica.DataManagement/organizations/", false);
            uri.AppendPath(organizationName, true);
            uri.AppendPath("/serverlessRuntimes", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> List InformaticaServerlessRuntimeResource resources by InformaticaOrganizationResource. </summary>
        /// <param name="subscriptionId"> The ID of the target subscription. The value must be an UUID. </param>
        /// <param name="resourceGroupName"> The name of the resource group. The name is case insensitive. </param>
        /// <param name="organizationName"> Name of the Organizations resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/> or <paramref name="organizationName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/> or <paramref name="organizationName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<InformaticaServerlessRuntimeResourceListResult>> ListByInformaticaOrganizationResourceAsync(string subscriptionId, string resourceGroupName, string organizationName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(organizationName, nameof(organizationName));

            using var message = CreateListByInformaticaOrganizationResourceRequest(subscriptionId, resourceGroupName, organizationName);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        InformaticaServerlessRuntimeResourceListResult value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = InformaticaServerlessRuntimeResourceListResult.DeserializeInformaticaServerlessRuntimeResourceListResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> List InformaticaServerlessRuntimeResource resources by InformaticaOrganizationResource. </summary>
        /// <param name="subscriptionId"> The ID of the target subscription. The value must be an UUID. </param>
        /// <param name="resourceGroupName"> The name of the resource group. The name is case insensitive. </param>
        /// <param name="organizationName"> Name of the Organizations resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/> or <paramref name="organizationName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/> or <paramref name="organizationName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<InformaticaServerlessRuntimeResourceListResult> ListByInformaticaOrganizationResource(string subscriptionId, string resourceGroupName, string organizationName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(organizationName, nameof(organizationName));

            using var message = CreateListByInformaticaOrganizationResourceRequest(subscriptionId, resourceGroupName, organizationName);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        InformaticaServerlessRuntimeResourceListResult value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = InformaticaServerlessRuntimeResourceListResult.DeserializeInformaticaServerlessRuntimeResourceListResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateUpdateRequestUri(string subscriptionId, string resourceGroupName, string organizationName, string serverlessRuntimeName, InformaticaServerlessRuntimePatch patch)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Informatica.DataManagement/organizations/", false);
            uri.AppendPath(organizationName, true);
            uri.AppendPath("/serverlessRuntimes/", false);
            uri.AppendPath(serverlessRuntimeName, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateUpdateRequest(string subscriptionId, string resourceGroupName, string organizationName, string serverlessRuntimeName, InformaticaServerlessRuntimePatch patch)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Patch;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Informatica.DataManagement/organizations/", false);
            uri.AppendPath(organizationName, true);
            uri.AppendPath("/serverlessRuntimes/", false);
            uri.AppendPath(serverlessRuntimeName, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(patch, ModelSerializationExtensions.WireOptions);
            request.Content = content;
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Update a InformaticaServerlessRuntimeResource. </summary>
        /// <param name="subscriptionId"> The ID of the target subscription. The value must be an UUID. </param>
        /// <param name="resourceGroupName"> The name of the resource group. The name is case insensitive. </param>
        /// <param name="organizationName"> Name of the Organizations resource. </param>
        /// <param name="serverlessRuntimeName"> Name of the Serverless Runtime resource. </param>
        /// <param name="patch"> The resource properties to be updated. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="organizationName"/>, <paramref name="serverlessRuntimeName"/> or <paramref name="patch"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="organizationName"/> or <paramref name="serverlessRuntimeName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<InformaticaServerlessRuntimeData>> UpdateAsync(string subscriptionId, string resourceGroupName, string organizationName, string serverlessRuntimeName, InformaticaServerlessRuntimePatch patch, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(organizationName, nameof(organizationName));
            Argument.AssertNotNullOrEmpty(serverlessRuntimeName, nameof(serverlessRuntimeName));
            Argument.AssertNotNull(patch, nameof(patch));

            using var message = CreateUpdateRequest(subscriptionId, resourceGroupName, organizationName, serverlessRuntimeName, patch);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        InformaticaServerlessRuntimeData value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = InformaticaServerlessRuntimeData.DeserializeInformaticaServerlessRuntimeData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Update a InformaticaServerlessRuntimeResource. </summary>
        /// <param name="subscriptionId"> The ID of the target subscription. The value must be an UUID. </param>
        /// <param name="resourceGroupName"> The name of the resource group. The name is case insensitive. </param>
        /// <param name="organizationName"> Name of the Organizations resource. </param>
        /// <param name="serverlessRuntimeName"> Name of the Serverless Runtime resource. </param>
        /// <param name="patch"> The resource properties to be updated. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="organizationName"/>, <paramref name="serverlessRuntimeName"/> or <paramref name="patch"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="organizationName"/> or <paramref name="serverlessRuntimeName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<InformaticaServerlessRuntimeData> Update(string subscriptionId, string resourceGroupName, string organizationName, string serverlessRuntimeName, InformaticaServerlessRuntimePatch patch, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(organizationName, nameof(organizationName));
            Argument.AssertNotNullOrEmpty(serverlessRuntimeName, nameof(serverlessRuntimeName));
            Argument.AssertNotNull(patch, nameof(patch));

            using var message = CreateUpdateRequest(subscriptionId, resourceGroupName, organizationName, serverlessRuntimeName, patch);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        InformaticaServerlessRuntimeData value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = InformaticaServerlessRuntimeData.DeserializeInformaticaServerlessRuntimeData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateCheckDependenciesRequestUri(string subscriptionId, string resourceGroupName, string organizationName, string serverlessRuntimeName)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Informatica.DataManagement/organizations/", false);
            uri.AppendPath(organizationName, true);
            uri.AppendPath("/serverlessRuntimes/", false);
            uri.AppendPath(serverlessRuntimeName, true);
            uri.AppendPath("/checkDependencies", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateCheckDependenciesRequest(string subscriptionId, string resourceGroupName, string organizationName, string serverlessRuntimeName)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Informatica.DataManagement/organizations/", false);
            uri.AppendPath(organizationName, true);
            uri.AppendPath("/serverlessRuntimes/", false);
            uri.AppendPath(serverlessRuntimeName, true);
            uri.AppendPath("/checkDependencies", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Checks all dependencies for a serverless runtime resource. </summary>
        /// <param name="subscriptionId"> The ID of the target subscription. The value must be an UUID. </param>
        /// <param name="resourceGroupName"> The name of the resource group. The name is case insensitive. </param>
        /// <param name="organizationName"> Name of the Organizations resource. </param>
        /// <param name="serverlessRuntimeName"> Name of the Serverless Runtime resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="organizationName"/> or <paramref name="serverlessRuntimeName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="organizationName"/> or <paramref name="serverlessRuntimeName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<CheckDependenciesResult>> CheckDependenciesAsync(string subscriptionId, string resourceGroupName, string organizationName, string serverlessRuntimeName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(organizationName, nameof(organizationName));
            Argument.AssertNotNullOrEmpty(serverlessRuntimeName, nameof(serverlessRuntimeName));

            using var message = CreateCheckDependenciesRequest(subscriptionId, resourceGroupName, organizationName, serverlessRuntimeName);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        CheckDependenciesResult value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = CheckDependenciesResult.DeserializeCheckDependenciesResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Checks all dependencies for a serverless runtime resource. </summary>
        /// <param name="subscriptionId"> The ID of the target subscription. The value must be an UUID. </param>
        /// <param name="resourceGroupName"> The name of the resource group. The name is case insensitive. </param>
        /// <param name="organizationName"> Name of the Organizations resource. </param>
        /// <param name="serverlessRuntimeName"> Name of the Serverless Runtime resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="organizationName"/> or <paramref name="serverlessRuntimeName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="organizationName"/> or <paramref name="serverlessRuntimeName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<CheckDependenciesResult> CheckDependencies(string subscriptionId, string resourceGroupName, string organizationName, string serverlessRuntimeName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(organizationName, nameof(organizationName));
            Argument.AssertNotNullOrEmpty(serverlessRuntimeName, nameof(serverlessRuntimeName));

            using var message = CreateCheckDependenciesRequest(subscriptionId, resourceGroupName, organizationName, serverlessRuntimeName);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        CheckDependenciesResult value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = CheckDependenciesResult.DeserializeCheckDependenciesResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateStartFailedServerlessRuntimeRequestUri(string subscriptionId, string resourceGroupName, string organizationName, string serverlessRuntimeName)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Informatica.DataManagement/organizations/", false);
            uri.AppendPath(organizationName, true);
            uri.AppendPath("/serverlessRuntimes/", false);
            uri.AppendPath(serverlessRuntimeName, true);
            uri.AppendPath("/startFailedServerlessRuntime", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateStartFailedServerlessRuntimeRequest(string subscriptionId, string resourceGroupName, string organizationName, string serverlessRuntimeName)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Informatica.DataManagement/organizations/", false);
            uri.AppendPath(organizationName, true);
            uri.AppendPath("/serverlessRuntimes/", false);
            uri.AppendPath(serverlessRuntimeName, true);
            uri.AppendPath("/startFailedServerlessRuntime", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Starts a failed runtime resource. </summary>
        /// <param name="subscriptionId"> The ID of the target subscription. The value must be an UUID. </param>
        /// <param name="resourceGroupName"> The name of the resource group. The name is case insensitive. </param>
        /// <param name="organizationName"> Name of the Organizations resource. </param>
        /// <param name="serverlessRuntimeName"> Name of the Serverless Runtime resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="organizationName"/> or <paramref name="serverlessRuntimeName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="organizationName"/> or <paramref name="serverlessRuntimeName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response> StartFailedServerlessRuntimeAsync(string subscriptionId, string resourceGroupName, string organizationName, string serverlessRuntimeName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(organizationName, nameof(organizationName));
            Argument.AssertNotNullOrEmpty(serverlessRuntimeName, nameof(serverlessRuntimeName));

            using var message = CreateStartFailedServerlessRuntimeRequest(subscriptionId, resourceGroupName, organizationName, serverlessRuntimeName);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Starts a failed runtime resource. </summary>
        /// <param name="subscriptionId"> The ID of the target subscription. The value must be an UUID. </param>
        /// <param name="resourceGroupName"> The name of the resource group. The name is case insensitive. </param>
        /// <param name="organizationName"> Name of the Organizations resource. </param>
        /// <param name="serverlessRuntimeName"> Name of the Serverless Runtime resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="organizationName"/> or <paramref name="serverlessRuntimeName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="organizationName"/> or <paramref name="serverlessRuntimeName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response StartFailedServerlessRuntime(string subscriptionId, string resourceGroupName, string organizationName, string serverlessRuntimeName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(organizationName, nameof(organizationName));
            Argument.AssertNotNullOrEmpty(serverlessRuntimeName, nameof(serverlessRuntimeName));

            using var message = CreateStartFailedServerlessRuntimeRequest(subscriptionId, resourceGroupName, organizationName, serverlessRuntimeName);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateGetServerlessResourceByIdRequestUri(string subscriptionId, string resourceGroupName, string organizationName, string serverlessRuntimeName)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Informatica.DataManagement/organizations/", false);
            uri.AppendPath(organizationName, true);
            uri.AppendPath("/serverlessRuntimes/", false);
            uri.AppendPath(serverlessRuntimeName, true);
            uri.AppendPath("/serverlessResourceById", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateGetServerlessResourceByIdRequest(string subscriptionId, string resourceGroupName, string organizationName, string serverlessRuntimeName)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Informatica.DataManagement/organizations/", false);
            uri.AppendPath(organizationName, true);
            uri.AppendPath("/serverlessRuntimes/", false);
            uri.AppendPath(serverlessRuntimeName, true);
            uri.AppendPath("/serverlessResourceById", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Returns a serverless runtime resource by ID. </summary>
        /// <param name="subscriptionId"> The ID of the target subscription. The value must be an UUID. </param>
        /// <param name="resourceGroupName"> The name of the resource group. The name is case insensitive. </param>
        /// <param name="organizationName"> Name of the Organizations resource. </param>
        /// <param name="serverlessRuntimeName"> Name of the Serverless Runtime resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="organizationName"/> or <paramref name="serverlessRuntimeName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="organizationName"/> or <paramref name="serverlessRuntimeName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<InformaticaServerlessRuntimeData>> GetServerlessResourceByIdAsync(string subscriptionId, string resourceGroupName, string organizationName, string serverlessRuntimeName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(organizationName, nameof(organizationName));
            Argument.AssertNotNullOrEmpty(serverlessRuntimeName, nameof(serverlessRuntimeName));

            using var message = CreateGetServerlessResourceByIdRequest(subscriptionId, resourceGroupName, organizationName, serverlessRuntimeName);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        InformaticaServerlessRuntimeData value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = InformaticaServerlessRuntimeData.DeserializeInformaticaServerlessRuntimeData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Returns a serverless runtime resource by ID. </summary>
        /// <param name="subscriptionId"> The ID of the target subscription. The value must be an UUID. </param>
        /// <param name="resourceGroupName"> The name of the resource group. The name is case insensitive. </param>
        /// <param name="organizationName"> Name of the Organizations resource. </param>
        /// <param name="serverlessRuntimeName"> Name of the Serverless Runtime resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="organizationName"/> or <paramref name="serverlessRuntimeName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="organizationName"/> or <paramref name="serverlessRuntimeName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<InformaticaServerlessRuntimeData> GetServerlessResourceById(string subscriptionId, string resourceGroupName, string organizationName, string serverlessRuntimeName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(organizationName, nameof(organizationName));
            Argument.AssertNotNullOrEmpty(serverlessRuntimeName, nameof(serverlessRuntimeName));

            using var message = CreateGetServerlessResourceByIdRequest(subscriptionId, resourceGroupName, organizationName, serverlessRuntimeName);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        InformaticaServerlessRuntimeData value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = InformaticaServerlessRuntimeData.DeserializeInformaticaServerlessRuntimeData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateListByInformaticaOrganizationResourceNextPageRequestUri(string nextLink, string subscriptionId, string resourceGroupName, string organizationName)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            return uri;
        }

        internal HttpMessage CreateListByInformaticaOrganizationResourceNextPageRequest(string nextLink, string subscriptionId, string resourceGroupName, string organizationName)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> List InformaticaServerlessRuntimeResource resources by InformaticaOrganizationResource. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="subscriptionId"> The ID of the target subscription. The value must be an UUID. </param>
        /// <param name="resourceGroupName"> The name of the resource group. The name is case insensitive. </param>
        /// <param name="organizationName"> Name of the Organizations resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/>, <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/> or <paramref name="organizationName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/> or <paramref name="organizationName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<InformaticaServerlessRuntimeResourceListResult>> ListByInformaticaOrganizationResourceNextPageAsync(string nextLink, string subscriptionId, string resourceGroupName, string organizationName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(nextLink, nameof(nextLink));
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(organizationName, nameof(organizationName));

            using var message = CreateListByInformaticaOrganizationResourceNextPageRequest(nextLink, subscriptionId, resourceGroupName, organizationName);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        InformaticaServerlessRuntimeResourceListResult value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = InformaticaServerlessRuntimeResourceListResult.DeserializeInformaticaServerlessRuntimeResourceListResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> List InformaticaServerlessRuntimeResource resources by InformaticaOrganizationResource. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="subscriptionId"> The ID of the target subscription. The value must be an UUID. </param>
        /// <param name="resourceGroupName"> The name of the resource group. The name is case insensitive. </param>
        /// <param name="organizationName"> Name of the Organizations resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/>, <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/> or <paramref name="organizationName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/> or <paramref name="organizationName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<InformaticaServerlessRuntimeResourceListResult> ListByInformaticaOrganizationResourceNextPage(string nextLink, string subscriptionId, string resourceGroupName, string organizationName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(nextLink, nameof(nextLink));
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(organizationName, nameof(organizationName));

            using var message = CreateListByInformaticaOrganizationResourceNextPageRequest(nextLink, subscriptionId, resourceGroupName, organizationName);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        InformaticaServerlessRuntimeResourceListResult value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = InformaticaServerlessRuntimeResourceListResult.DeserializeInformaticaServerlessRuntimeResourceListResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }
    }
}
