// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.InformaticaDataManagement.Models
{
    internal partial class ServerlessRuntimeNetworkProfileUpdate : IUtf8JsonSerializable, IJsonModel<ServerlessRuntimeNetworkProfileUpdate>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ServerlessRuntimeNetworkProfileUpdate>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ServerlessRuntimeNetworkProfileUpdate>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ServerlessRuntimeNetworkProfileUpdate>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ServerlessRuntimeNetworkProfileUpdate)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("networkInterfaceConfiguration"u8);
            writer.WriteObjectValue(NetworkInterfaceConfiguration, options);
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ServerlessRuntimeNetworkProfileUpdate IJsonModel<ServerlessRuntimeNetworkProfileUpdate>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ServerlessRuntimeNetworkProfileUpdate>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ServerlessRuntimeNetworkProfileUpdate)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeServerlessRuntimeNetworkProfileUpdate(document.RootElement, options);
        }

        internal static ServerlessRuntimeNetworkProfileUpdate DeserializeServerlessRuntimeNetworkProfileUpdate(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            InformaticaNetworkInterfaceConfigurationUpdate networkInterfaceConfiguration = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("networkInterfaceConfiguration"u8))
                {
                    networkInterfaceConfiguration = InformaticaNetworkInterfaceConfigurationUpdate.DeserializeInformaticaNetworkInterfaceConfigurationUpdate(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ServerlessRuntimeNetworkProfileUpdate(networkInterfaceConfiguration, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ServerlessRuntimeNetworkProfileUpdate>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ServerlessRuntimeNetworkProfileUpdate>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ServerlessRuntimeNetworkProfileUpdate)} does not support writing '{options.Format}' format.");
            }
        }

        ServerlessRuntimeNetworkProfileUpdate IPersistableModel<ServerlessRuntimeNetworkProfileUpdate>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ServerlessRuntimeNetworkProfileUpdate>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeServerlessRuntimeNetworkProfileUpdate(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ServerlessRuntimeNetworkProfileUpdate)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ServerlessRuntimeNetworkProfileUpdate>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
