// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.InformaticaDataManagement.Models
{
    public partial class ServerlessRuntimeConfigPropertiesUpdate : IUtf8JsonSerializable, IJsonModel<ServerlessRuntimeConfigPropertiesUpdate>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ServerlessRuntimeConfigPropertiesUpdate>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ServerlessRuntimeConfigPropertiesUpdate>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ServerlessRuntimeConfigPropertiesUpdate>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ServerlessRuntimeConfigPropertiesUpdate)} does not support writing '{format}' format.");
            }

            if (Optional.IsCollectionDefined(CdiConfigProps))
            {
                writer.WritePropertyName("cdiConfigProps"u8);
                writer.WriteStartArray();
                foreach (var item in CdiConfigProps)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(CdieConfigProps))
            {
                writer.WritePropertyName("cdieConfigProps"u8);
                writer.WriteStartArray();
                foreach (var item in CdieConfigProps)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ServerlessRuntimeConfigPropertiesUpdate IJsonModel<ServerlessRuntimeConfigPropertiesUpdate>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ServerlessRuntimeConfigPropertiesUpdate>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ServerlessRuntimeConfigPropertiesUpdate)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeServerlessRuntimeConfigPropertiesUpdate(document.RootElement, options);
        }

        internal static ServerlessRuntimeConfigPropertiesUpdate DeserializeServerlessRuntimeConfigPropertiesUpdate(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IList<CdiConfigProperties> cdiConfigProps = default;
            IList<CdiConfigProperties> cdieConfigProps = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("cdiConfigProps"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<CdiConfigProperties> array = new List<CdiConfigProperties>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(CdiConfigProperties.DeserializeCdiConfigProperties(item, options));
                    }
                    cdiConfigProps = array;
                    continue;
                }
                if (property.NameEquals("cdieConfigProps"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<CdiConfigProperties> array = new List<CdiConfigProperties>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(CdiConfigProperties.DeserializeCdiConfigProperties(item, options));
                    }
                    cdieConfigProps = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ServerlessRuntimeConfigPropertiesUpdate(cdiConfigProps ?? new ChangeTrackingList<CdiConfigProperties>(), cdieConfigProps ?? new ChangeTrackingList<CdiConfigProperties>(), serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ServerlessRuntimeConfigPropertiesUpdate>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ServerlessRuntimeConfigPropertiesUpdate>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ServerlessRuntimeConfigPropertiesUpdate)} does not support writing '{options.Format}' format.");
            }
        }

        ServerlessRuntimeConfigPropertiesUpdate IPersistableModel<ServerlessRuntimeConfigPropertiesUpdate>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ServerlessRuntimeConfigPropertiesUpdate>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeServerlessRuntimeConfigPropertiesUpdate(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ServerlessRuntimeConfigPropertiesUpdate)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ServerlessRuntimeConfigPropertiesUpdate>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
