// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.InformaticaDataManagement.Models
{
    /// <summary> Serverless Runtime config properties. </summary>
    public partial class ServerlessRuntimeConfigProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ServerlessRuntimeConfigProperties"/>. </summary>
        public ServerlessRuntimeConfigProperties()
        {
            CdiConfigProps = new ChangeTrackingList<CdiConfigProperties>();
            CdieConfigProps = new ChangeTrackingList<CdiConfigProperties>();
        }

        /// <summary> Initializes a new instance of <see cref="ServerlessRuntimeConfigProperties"/>. </summary>
        /// <param name="cdiConfigProps"> The List of Informatica Serverless Runtime CDI Config Properties. </param>
        /// <param name="cdieConfigProps"> The List of Informatica Serverless Runtime CDIE Config Properties. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ServerlessRuntimeConfigProperties(IList<CdiConfigProperties> cdiConfigProps, IList<CdiConfigProperties> cdieConfigProps, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            CdiConfigProps = cdiConfigProps;
            CdieConfigProps = cdieConfigProps;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The List of Informatica Serverless Runtime CDI Config Properties. </summary>
        public IList<CdiConfigProperties> CdiConfigProps { get; }
        /// <summary> The List of Informatica Serverless Runtime CDIE Config Properties. </summary>
        public IList<CdiConfigProperties> CdieConfigProps { get; }
    }
}
