// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.InformaticaDataManagement.Models
{
    /// <summary> Serverless Runtime environment Metadata response. </summary>
    public partial class ServerlessMetadataResponse
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ServerlessMetadataResponse"/>. </summary>
        internal ServerlessMetadataResponse()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ServerlessMetadataResponse"/>. </summary>
        /// <param name="runtimeType"> type of the runtime environment. </param>
        /// <param name="serverlessConfigProperties"> serverless config properties. </param>
        /// <param name="serverlessRuntimeConfigProperties"> serverless runtime config properties. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ServerlessMetadataResponse(InformaticaRuntimeType? runtimeType, ServerlessConfigProperties serverlessConfigProperties, ServerlessRuntimeConfigProperties serverlessRuntimeConfigProperties, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            RuntimeType = runtimeType;
            ServerlessConfigProperties = serverlessConfigProperties;
            ServerlessRuntimeConfigProperties = serverlessRuntimeConfigProperties;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> type of the runtime environment. </summary>
        public InformaticaRuntimeType? RuntimeType { get; }
        /// <summary> serverless config properties. </summary>
        public ServerlessConfigProperties ServerlessConfigProperties { get; }
        /// <summary> serverless runtime config properties. </summary>
        public ServerlessRuntimeConfigProperties ServerlessRuntimeConfigProperties { get; }
    }
}
