// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.InformaticaDataManagement.Models
{
    public partial class ServerlessConfigProperties : IUtf8JsonSerializable, IJsonModel<ServerlessConfigProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ServerlessConfigProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ServerlessConfigProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ServerlessConfigProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ServerlessConfigProperties)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(Platform))
            {
                writer.WritePropertyName("platform"u8);
                writer.WriteStringValue(Platform.Value.ToString());
            }
            if (Optional.IsCollectionDefined(ApplicationTypes))
            {
                writer.WritePropertyName("applicationTypes"u8);
                writer.WriteStartArray();
                foreach (var item in ApplicationTypes)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(ComputeUnits))
            {
                writer.WritePropertyName("computeUnits"u8);
                writer.WriteStartArray();
                foreach (var item in ComputeUnits)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(ExecutionTimeout))
            {
                writer.WritePropertyName("executionTimeout"u8);
                writer.WriteStringValue(ExecutionTimeout);
            }
            if (Optional.IsCollectionDefined(Regions))
            {
                writer.WritePropertyName("regions"u8);
                writer.WriteStartArray();
                foreach (var item in Regions)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ServerlessConfigProperties IJsonModel<ServerlessConfigProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ServerlessConfigProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ServerlessConfigProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeServerlessConfigProperties(document.RootElement, options);
        }

        internal static ServerlessConfigProperties DeserializeServerlessConfigProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            InformaticaPlatformType? platform = default;
            IReadOnlyList<InformaticaApplicationTypeMetadata> applicationTypes = default;
            IReadOnlyList<ComputeUnitsMetadata> computeUnits = default;
            string executionTimeout = default;
            IReadOnlyList<InformaticaRegionsMetadata> regions = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("platform"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    platform = new InformaticaPlatformType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("applicationTypes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<InformaticaApplicationTypeMetadata> array = new List<InformaticaApplicationTypeMetadata>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(InformaticaApplicationTypeMetadata.DeserializeInformaticaApplicationTypeMetadata(item, options));
                    }
                    applicationTypes = array;
                    continue;
                }
                if (property.NameEquals("computeUnits"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ComputeUnitsMetadata> array = new List<ComputeUnitsMetadata>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ComputeUnitsMetadata.DeserializeComputeUnitsMetadata(item, options));
                    }
                    computeUnits = array;
                    continue;
                }
                if (property.NameEquals("executionTimeout"u8))
                {
                    executionTimeout = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("regions"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<InformaticaRegionsMetadata> array = new List<InformaticaRegionsMetadata>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(InformaticaRegionsMetadata.DeserializeInformaticaRegionsMetadata(item, options));
                    }
                    regions = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ServerlessConfigProperties(
                platform,
                applicationTypes ?? new ChangeTrackingList<InformaticaApplicationTypeMetadata>(),
                computeUnits ?? new ChangeTrackingList<ComputeUnitsMetadata>(),
                executionTimeout,
                regions ?? new ChangeTrackingList<InformaticaRegionsMetadata>(),
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ServerlessConfigProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ServerlessConfigProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ServerlessConfigProperties)} does not support writing '{options.Format}' format.");
            }
        }

        ServerlessConfigProperties IPersistableModel<ServerlessConfigProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ServerlessConfigProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeServerlessConfigProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ServerlessConfigProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ServerlessConfigProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
