// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.InformaticaDataManagement.Models
{
    /// <summary> User Info of Informatica Organization resource. </summary>
    public partial class InformaticaUserDetailsUpdate
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="InformaticaUserDetailsUpdate"/>. </summary>
        public InformaticaUserDetailsUpdate()
        {
        }

        /// <summary> Initializes a new instance of <see cref="InformaticaUserDetailsUpdate"/>. </summary>
        /// <param name="firstName"> User first name. </param>
        /// <param name="lastName"> User last name. </param>
        /// <param name="emailAddress"> User email address. </param>
        /// <param name="upn"> UPN of user. </param>
        /// <param name="phoneNumber"> Phone number of the user used by for contacting them if needed. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal InformaticaUserDetailsUpdate(string firstName, string lastName, string emailAddress, string upn, string phoneNumber, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            FirstName = firstName;
            LastName = lastName;
            EmailAddress = emailAddress;
            Upn = upn;
            PhoneNumber = phoneNumber;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> User first name. </summary>
        public string FirstName { get; set; }
        /// <summary> User last name. </summary>
        public string LastName { get; set; }
        /// <summary> User email address. </summary>
        public string EmailAddress { get; set; }
        /// <summary> UPN of user. </summary>
        public string Upn { get; set; }
        /// <summary> Phone number of the user used by for contacting them if needed. </summary>
        public string PhoneNumber { get; set; }
    }
}
