// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.InformaticaDataManagement.Models
{
    public partial class InformaticaServerlessRuntimeResourceList : IUtf8JsonSerializable, IJsonModel<InformaticaServerlessRuntimeResourceList>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<InformaticaServerlessRuntimeResourceList>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<InformaticaServerlessRuntimeResourceList>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InformaticaServerlessRuntimeResourceList>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(InformaticaServerlessRuntimeResourceList)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("informaticaRuntimeResources"u8);
            writer.WriteStartArray();
            foreach (var item in InformaticaRuntimeResources)
            {
                writer.WriteObjectValue(item, options);
            }
            writer.WriteEndArray();
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        InformaticaServerlessRuntimeResourceList IJsonModel<InformaticaServerlessRuntimeResourceList>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InformaticaServerlessRuntimeResourceList>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(InformaticaServerlessRuntimeResourceList)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeInformaticaServerlessRuntimeResourceList(document.RootElement, options);
        }

        internal static InformaticaServerlessRuntimeResourceList DeserializeInformaticaServerlessRuntimeResourceList(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IReadOnlyList<InformaticaRuntimeResourceFetchMetadata> informaticaRuntimeResources = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("informaticaRuntimeResources"u8))
                {
                    List<InformaticaRuntimeResourceFetchMetadata> array = new List<InformaticaRuntimeResourceFetchMetadata>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(InformaticaRuntimeResourceFetchMetadata.DeserializeInformaticaRuntimeResourceFetchMetadata(item, options));
                    }
                    informaticaRuntimeResources = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new InformaticaServerlessRuntimeResourceList(informaticaRuntimeResources, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<InformaticaServerlessRuntimeResourceList>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InformaticaServerlessRuntimeResourceList>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(InformaticaServerlessRuntimeResourceList)} does not support writing '{options.Format}' format.");
            }
        }

        InformaticaServerlessRuntimeResourceList IPersistableModel<InformaticaServerlessRuntimeResourceList>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InformaticaServerlessRuntimeResourceList>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeInformaticaServerlessRuntimeResourceList(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(InformaticaServerlessRuntimeResourceList)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<InformaticaServerlessRuntimeResourceList>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
