// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.InformaticaDataManagement.Models
{
    /// <summary> Various types of the runtime types. </summary>
    public readonly partial struct InformaticaRuntimeType : IEquatable<InformaticaRuntimeType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="InformaticaRuntimeType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public InformaticaRuntimeType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ServerlessValue = "SERVERLESS";

        /// <summary> Serverless Runtime type. </summary>
        public static InformaticaRuntimeType Serverless { get; } = new InformaticaRuntimeType(ServerlessValue);
        /// <summary> Determines if two <see cref="InformaticaRuntimeType"/> values are the same. </summary>
        public static bool operator ==(InformaticaRuntimeType left, InformaticaRuntimeType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="InformaticaRuntimeType"/> values are not the same. </summary>
        public static bool operator !=(InformaticaRuntimeType left, InformaticaRuntimeType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="InformaticaRuntimeType"/>. </summary>
        public static implicit operator InformaticaRuntimeType(string value) => new InformaticaRuntimeType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is InformaticaRuntimeType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(InformaticaRuntimeType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
