// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.InformaticaDataManagement.Models
{
    public partial class InformaticaRuntimeResourceFetchMetadata : IUtf8JsonSerializable, IJsonModel<InformaticaRuntimeResourceFetchMetadata>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<InformaticaRuntimeResourceFetchMetadata>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<InformaticaRuntimeResourceFetchMetadata>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InformaticaRuntimeResourceFetchMetadata>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(InformaticaRuntimeResourceFetchMetadata)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("name"u8);
            writer.WriteStringValue(Name);
            writer.WritePropertyName("createdTime"u8);
            writer.WriteStringValue(CreatedTime);
            writer.WritePropertyName("updatedTime"u8);
            writer.WriteStringValue(UpdatedTime);
            writer.WritePropertyName("createdBy"u8);
            writer.WriteStringValue(CreatedBy);
            writer.WritePropertyName("updatedBy"u8);
            writer.WriteStringValue(UpdatedBy);
            writer.WritePropertyName("id"u8);
            writer.WriteStringValue(Id);
            writer.WritePropertyName("type"u8);
            writer.WriteStringValue(RuntimeType.ToString());
            writer.WritePropertyName("status"u8);
            writer.WriteStringValue(Status);
            writer.WritePropertyName("statusLocalized"u8);
            writer.WriteStringValue(StatusLocalized);
            writer.WritePropertyName("statusMessage"u8);
            writer.WriteStringValue(StatusMessage);
            writer.WritePropertyName("serverlessConfigProperties"u8);
            writer.WriteObjectValue(ServerlessConfigProperties, options);
            if (Optional.IsDefined(Description))
            {
                writer.WritePropertyName("description"u8);
                writer.WriteStringValue(Description);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        InformaticaRuntimeResourceFetchMetadata IJsonModel<InformaticaRuntimeResourceFetchMetadata>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InformaticaRuntimeResourceFetchMetadata>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(InformaticaRuntimeResourceFetchMetadata)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeInformaticaRuntimeResourceFetchMetadata(document.RootElement, options);
        }

        internal static InformaticaRuntimeResourceFetchMetadata DeserializeInformaticaRuntimeResourceFetchMetadata(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string name = default;
            string createdTime = default;
            string updatedTime = default;
            string createdBy = default;
            string updatedBy = default;
            string id = default;
            InformaticaRuntimeType type = default;
            string status = default;
            string statusLocalized = default;
            string statusMessage = default;
            InformaticaServerlessFetchConfigProperties serverlessConfigProperties = default;
            string description = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("createdTime"u8))
                {
                    createdTime = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("updatedTime"u8))
                {
                    updatedTime = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("createdBy"u8))
                {
                    createdBy = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("updatedBy"u8))
                {
                    updatedBy = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("id"u8))
                {
                    id = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new InformaticaRuntimeType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("status"u8))
                {
                    status = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("statusLocalized"u8))
                {
                    statusLocalized = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("statusMessage"u8))
                {
                    statusMessage = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("serverlessConfigProperties"u8))
                {
                    serverlessConfigProperties = InformaticaServerlessFetchConfigProperties.DeserializeInformaticaServerlessFetchConfigProperties(property.Value, options);
                    continue;
                }
                if (property.NameEquals("description"u8))
                {
                    description = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new InformaticaRuntimeResourceFetchMetadata(
                name,
                createdTime,
                updatedTime,
                createdBy,
                updatedBy,
                id,
                type,
                status,
                statusLocalized,
                statusMessage,
                serverlessConfigProperties,
                description,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<InformaticaRuntimeResourceFetchMetadata>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InformaticaRuntimeResourceFetchMetadata>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(InformaticaRuntimeResourceFetchMetadata)} does not support writing '{options.Format}' format.");
            }
        }

        InformaticaRuntimeResourceFetchMetadata IPersistableModel<InformaticaRuntimeResourceFetchMetadata>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InformaticaRuntimeResourceFetchMetadata>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeInformaticaRuntimeResourceFetchMetadata(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(InformaticaRuntimeResourceFetchMetadata)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<InformaticaRuntimeResourceFetchMetadata>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
