// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.InformaticaDataManagement.Models
{
    /// <summary> Provisioning State of the Organization resource. </summary>
    public readonly partial struct InformaticaProvisioningState : IEquatable<InformaticaProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="InformaticaProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public InformaticaProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AcceptedValue = "Accepted";
        private const string CreatingValue = "Creating";
        private const string UpdatingValue = "Updating";
        private const string DeletingValue = "Deleting";
        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";
        private const string DeletedValue = "Deleted";
        private const string NotSpecifiedValue = "NotSpecified";

        /// <summary> Organization resource creation request accepted. </summary>
        public static InformaticaProvisioningState Accepted { get; } = new InformaticaProvisioningState(AcceptedValue);
        /// <summary> Organization resource creation started. </summary>
        public static InformaticaProvisioningState Creating { get; } = new InformaticaProvisioningState(CreatingValue);
        /// <summary> Organization resource is being updated. </summary>
        public static InformaticaProvisioningState Updating { get; } = new InformaticaProvisioningState(UpdatingValue);
        /// <summary> Organization resource deletion started. </summary>
        public static InformaticaProvisioningState Deleting { get; } = new InformaticaProvisioningState(DeletingValue);
        /// <summary> Organization resource creation successful. </summary>
        public static InformaticaProvisioningState Succeeded { get; } = new InformaticaProvisioningState(SucceededValue);
        /// <summary> Organization resource creation failed. </summary>
        public static InformaticaProvisioningState Failed { get; } = new InformaticaProvisioningState(FailedValue);
        /// <summary> Organization resource creation canceled. </summary>
        public static InformaticaProvisioningState Canceled { get; } = new InformaticaProvisioningState(CanceledValue);
        /// <summary> Organization resource is deleted. </summary>
        public static InformaticaProvisioningState Deleted { get; } = new InformaticaProvisioningState(DeletedValue);
        /// <summary> Organization resource state is unknown. </summary>
        public static InformaticaProvisioningState NotSpecified { get; } = new InformaticaProvisioningState(NotSpecifiedValue);
        /// <summary> Determines if two <see cref="InformaticaProvisioningState"/> values are the same. </summary>
        public static bool operator ==(InformaticaProvisioningState left, InformaticaProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="InformaticaProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(InformaticaProvisioningState left, InformaticaProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="InformaticaProvisioningState"/>. </summary>
        public static implicit operator InformaticaProvisioningState(string value) => new InformaticaProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is InformaticaProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(InformaticaProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
