// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.InformaticaDataManagement.Models
{
    public partial class InformaticaOrganizationPropertiesUpdate : IUtf8JsonSerializable, IJsonModel<InformaticaOrganizationPropertiesUpdate>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<InformaticaOrganizationPropertiesUpdate>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<InformaticaOrganizationPropertiesUpdate>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InformaticaOrganizationPropertiesUpdate>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(InformaticaOrganizationPropertiesUpdate)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(InformaticaOrganizationProperties))
            {
                writer.WritePropertyName("informaticaOrganizationProperties"u8);
                writer.WriteObjectValue(InformaticaOrganizationProperties, options);
            }
            if (Optional.IsDefined(MarketplaceDetails))
            {
                writer.WritePropertyName("marketplaceDetails"u8);
                writer.WriteObjectValue(MarketplaceDetails, options);
            }
            if (Optional.IsDefined(UserDetails))
            {
                writer.WritePropertyName("userDetails"u8);
                writer.WriteObjectValue(UserDetails, options);
            }
            if (Optional.IsDefined(CompanyDetails))
            {
                writer.WritePropertyName("companyDetails"u8);
                writer.WriteObjectValue(CompanyDetails, options);
            }
            if (Optional.IsDefined(ExistingResourceId))
            {
                writer.WritePropertyName("existingResourceId"u8);
                writer.WriteStringValue(ExistingResourceId);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        InformaticaOrganizationPropertiesUpdate IJsonModel<InformaticaOrganizationPropertiesUpdate>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InformaticaOrganizationPropertiesUpdate>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(InformaticaOrganizationPropertiesUpdate)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeInformaticaOrganizationPropertiesUpdate(document.RootElement, options);
        }

        internal static InformaticaOrganizationPropertiesUpdate DeserializeInformaticaOrganizationPropertiesUpdate(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            InformaticaOrganizationPatch informaticaOrganizationProperties = default;
            InformaticaMarketplaceDetailsUpdate marketplaceDetails = default;
            InformaticaUserDetailsUpdate userDetails = default;
            InformaticaCompanyDetailsUpdate companyDetails = default;
            ResourceIdentifier existingResourceId = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("informaticaOrganizationProperties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    informaticaOrganizationProperties = InformaticaOrganizationPatch.DeserializeInformaticaOrganizationPatch(property.Value, options);
                    continue;
                }
                if (property.NameEquals("marketplaceDetails"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    marketplaceDetails = InformaticaMarketplaceDetailsUpdate.DeserializeInformaticaMarketplaceDetailsUpdate(property.Value, options);
                    continue;
                }
                if (property.NameEquals("userDetails"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    userDetails = InformaticaUserDetailsUpdate.DeserializeInformaticaUserDetailsUpdate(property.Value, options);
                    continue;
                }
                if (property.NameEquals("companyDetails"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    companyDetails = InformaticaCompanyDetailsUpdate.DeserializeInformaticaCompanyDetailsUpdate(property.Value, options);
                    continue;
                }
                if (property.NameEquals("existingResourceId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    existingResourceId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new InformaticaOrganizationPropertiesUpdate(
                informaticaOrganizationProperties,
                marketplaceDetails,
                userDetails,
                companyDetails,
                existingResourceId,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<InformaticaOrganizationPropertiesUpdate>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InformaticaOrganizationPropertiesUpdate>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(InformaticaOrganizationPropertiesUpdate)} does not support writing '{options.Format}' format.");
            }
        }

        InformaticaOrganizationPropertiesUpdate IPersistableModel<InformaticaOrganizationPropertiesUpdate>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InformaticaOrganizationPropertiesUpdate>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeInformaticaOrganizationPropertiesUpdate(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(InformaticaOrganizationPropertiesUpdate)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<InformaticaOrganizationPropertiesUpdate>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
