// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.InformaticaDataManagement.Models
{
    /// <summary> Details of the product offering. </summary>
    public partial class InformaticaOfferDetailsUpdate
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="InformaticaOfferDetailsUpdate"/>. </summary>
        public InformaticaOfferDetailsUpdate()
        {
        }

        /// <summary> Initializes a new instance of <see cref="InformaticaOfferDetailsUpdate"/>. </summary>
        /// <param name="publisherId"> Id of the product publisher. </param>
        /// <param name="offerId"> Id of the product offering. </param>
        /// <param name="planId"> Id of the product offer plan. </param>
        /// <param name="planName"> Name of the product offer plan. </param>
        /// <param name="termUnit"> Offer plan term unit. </param>
        /// <param name="termId"> Offer plan term id. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal InformaticaOfferDetailsUpdate(string publisherId, string offerId, string planId, string planName, string termUnit, string termId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PublisherId = publisherId;
            OfferId = offerId;
            PlanId = planId;
            PlanName = planName;
            TermUnit = termUnit;
            TermId = termId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Id of the product publisher. </summary>
        public string PublisherId { get; set; }
        /// <summary> Id of the product offering. </summary>
        public string OfferId { get; set; }
        /// <summary> Id of the product offer plan. </summary>
        public string PlanId { get; set; }
        /// <summary> Name of the product offer plan. </summary>
        public string PlanName { get; set; }
        /// <summary> Offer plan term unit. </summary>
        public string TermUnit { get; set; }
        /// <summary> Offer plan term id. </summary>
        public string TermId { get; set; }
    }
}
