// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.InformaticaDataManagement.Models
{
    /// <summary> Marketplace details. </summary>
    public partial class InformaticaMarketplaceDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="InformaticaMarketplaceDetails"/>. </summary>
        /// <param name="offerDetails"> Marketplace offer details. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="offerDetails"/> is null. </exception>
        public InformaticaMarketplaceDetails(InformaticaOfferDetails offerDetails)
        {
            Argument.AssertNotNull(offerDetails, nameof(offerDetails));

            OfferDetails = offerDetails;
        }

        /// <summary> Initializes a new instance of <see cref="InformaticaMarketplaceDetails"/>. </summary>
        /// <param name="marketplaceSubscriptionId"> Marketplace Subscription Id. </param>
        /// <param name="offerDetails"> Marketplace offer details. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal InformaticaMarketplaceDetails(string marketplaceSubscriptionId, InformaticaOfferDetails offerDetails, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            MarketplaceSubscriptionId = marketplaceSubscriptionId;
            OfferDetails = offerDetails;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="InformaticaMarketplaceDetails"/> for deserialization. </summary>
        internal InformaticaMarketplaceDetails()
        {
        }

        /// <summary> Marketplace Subscription Id. </summary>
        public string MarketplaceSubscriptionId { get; set; }
        /// <summary> Marketplace offer details. </summary>
        public InformaticaOfferDetails OfferDetails { get; set; }
    }
}
