// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.InformaticaDataManagement.Models
{
    /// <summary> Company details of Informatica Organization resource. </summary>
    public partial class InformaticaCompanyDetailsUpdate
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="InformaticaCompanyDetailsUpdate"/>. </summary>
        public InformaticaCompanyDetailsUpdate()
        {
        }

        /// <summary> Initializes a new instance of <see cref="InformaticaCompanyDetailsUpdate"/>. </summary>
        /// <param name="companyName"> company Name. </param>
        /// <param name="officeAddress"> Office Address. </param>
        /// <param name="country"> Country name. </param>
        /// <param name="domain"> Domain name. </param>
        /// <param name="business"> Business phone number. </param>
        /// <param name="numberOfEmployees"> Number Of Employees. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal InformaticaCompanyDetailsUpdate(string companyName, string officeAddress, string country, string domain, string business, int? numberOfEmployees, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            CompanyName = companyName;
            OfficeAddress = officeAddress;
            Country = country;
            Domain = domain;
            Business = business;
            NumberOfEmployees = numberOfEmployees;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> company Name. </summary>
        public string CompanyName { get; set; }
        /// <summary> Office Address. </summary>
        public string OfficeAddress { get; set; }
        /// <summary> Country name. </summary>
        public string Country { get; set; }
        /// <summary> Domain name. </summary>
        public string Domain { get; set; }
        /// <summary> Business phone number. </summary>
        public string Business { get; set; }
        /// <summary> Number Of Employees. </summary>
        public int? NumberOfEmployees { get; set; }
    }
}
