// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.InformaticaDataManagement.Models
{
    /// <summary> Various application types of the Serverless Runtime environments. </summary>
    public readonly partial struct InformaticaApplicationType : IEquatable<InformaticaApplicationType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="InformaticaApplicationType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public InformaticaApplicationType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CdiValue = "CDI";
        private const string CdieValue = "CDIE";

        /// <summary> Data Integration. </summary>
        public static InformaticaApplicationType Cdi { get; } = new InformaticaApplicationType(CdiValue);
        /// <summary> Advanced Data Integration. </summary>
        public static InformaticaApplicationType Cdie { get; } = new InformaticaApplicationType(CdieValue);
        /// <summary> Determines if two <see cref="InformaticaApplicationType"/> values are the same. </summary>
        public static bool operator ==(InformaticaApplicationType left, InformaticaApplicationType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="InformaticaApplicationType"/> values are not the same. </summary>
        public static bool operator !=(InformaticaApplicationType left, InformaticaApplicationType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="InformaticaApplicationType"/>. </summary>
        public static implicit operator InformaticaApplicationType(string value) => new InformaticaApplicationType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is InformaticaApplicationType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(InformaticaApplicationType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
