// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.InformaticaDataManagement.Models
{
    /// <summary> Application configs. </summary>
    public partial class InformaticaApplicationConfigs
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="InformaticaApplicationConfigs"/>. </summary>
        /// <param name="applicationConfigsType"> Type of the application config. </param>
        /// <param name="name"> Name of the application config. </param>
        /// <param name="value"> Value of the application config. </param>
        /// <param name="platform"> Platform type of the application config. </param>
        /// <param name="customized"> Customized value of the application config. </param>
        /// <param name="defaultValue"> Default value of the application config. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="applicationConfigsType"/>, <paramref name="name"/>, <paramref name="value"/>, <paramref name="platform"/>, <paramref name="customized"/> or <paramref name="defaultValue"/> is null. </exception>
        public InformaticaApplicationConfigs(string applicationConfigsType, string name, string value, string platform, string customized, string defaultValue)
        {
            Argument.AssertNotNull(applicationConfigsType, nameof(applicationConfigsType));
            Argument.AssertNotNull(name, nameof(name));
            Argument.AssertNotNull(value, nameof(value));
            Argument.AssertNotNull(platform, nameof(platform));
            Argument.AssertNotNull(customized, nameof(customized));
            Argument.AssertNotNull(defaultValue, nameof(defaultValue));

            ApplicationConfigsType = applicationConfigsType;
            Name = name;
            Value = value;
            Platform = platform;
            Customized = customized;
            DefaultValue = defaultValue;
        }

        /// <summary> Initializes a new instance of <see cref="InformaticaApplicationConfigs"/>. </summary>
        /// <param name="applicationConfigsType"> Type of the application config. </param>
        /// <param name="name"> Name of the application config. </param>
        /// <param name="value"> Value of the application config. </param>
        /// <param name="platform"> Platform type of the application config. </param>
        /// <param name="customized"> Customized value of the application config. </param>
        /// <param name="defaultValue"> Default value of the application config. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal InformaticaApplicationConfigs(string applicationConfigsType, string name, string value, string platform, string customized, string defaultValue, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ApplicationConfigsType = applicationConfigsType;
            Name = name;
            Value = value;
            Platform = platform;
            Customized = customized;
            DefaultValue = defaultValue;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="InformaticaApplicationConfigs"/> for deserialization. </summary>
        internal InformaticaApplicationConfigs()
        {
        }

        /// <summary> Type of the application config. </summary>
        public string ApplicationConfigsType { get; set; }
        /// <summary> Name of the application config. </summary>
        public string Name { get; set; }
        /// <summary> Value of the application config. </summary>
        public string Value { get; set; }
        /// <summary> Platform type of the application config. </summary>
        public string Platform { get; set; }
        /// <summary> Customized value of the application config. </summary>
        public string Customized { get; set; }
        /// <summary> Default value of the application config. </summary>
        public string DefaultValue { get; set; }
    }
}
