// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.InformaticaDataManagement.Models
{
    public partial class CdiConfigProperties : IUtf8JsonSerializable, IJsonModel<CdiConfigProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<CdiConfigProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<CdiConfigProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CdiConfigProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CdiConfigProperties)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("engineName"u8);
            writer.WriteStringValue(EngineName);
            writer.WritePropertyName("engineVersion"u8);
            writer.WriteStringValue(EngineVersion);
            writer.WritePropertyName("applicationConfigs"u8);
            writer.WriteStartArray();
            foreach (var item in ApplicationConfigs)
            {
                writer.WriteObjectValue(item, options);
            }
            writer.WriteEndArray();
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        CdiConfigProperties IJsonModel<CdiConfigProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CdiConfigProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CdiConfigProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeCdiConfigProperties(document.RootElement, options);
        }

        internal static CdiConfigProperties DeserializeCdiConfigProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string engineName = default;
            string engineVersion = default;
            IList<InformaticaApplicationConfigs> applicationConfigs = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("engineName"u8))
                {
                    engineName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("engineVersion"u8))
                {
                    engineVersion = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("applicationConfigs"u8))
                {
                    List<InformaticaApplicationConfigs> array = new List<InformaticaApplicationConfigs>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(InformaticaApplicationConfigs.DeserializeInformaticaApplicationConfigs(item, options));
                    }
                    applicationConfigs = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new CdiConfigProperties(engineName, engineVersion, applicationConfigs, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<CdiConfigProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CdiConfigProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(CdiConfigProperties)} does not support writing '{options.Format}' format.");
            }
        }

        CdiConfigProperties IPersistableModel<CdiConfigProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CdiConfigProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeCdiConfigProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(CdiConfigProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<CdiConfigProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
