// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.InformaticaDataManagement
{
    internal class InformaticaServerlessRuntimeOperationSource : IOperationSource<InformaticaServerlessRuntimeResource>
    {
        private readonly ArmClient _client;

        internal InformaticaServerlessRuntimeOperationSource(ArmClient client)
        {
            _client = client;
        }

        InformaticaServerlessRuntimeResource IOperationSource<InformaticaServerlessRuntimeResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = InformaticaServerlessRuntimeData.DeserializeInformaticaServerlessRuntimeData(document.RootElement);
            return new InformaticaServerlessRuntimeResource(_client, data);
        }

        async ValueTask<InformaticaServerlessRuntimeResource> IOperationSource<InformaticaServerlessRuntimeResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = InformaticaServerlessRuntimeData.DeserializeInformaticaServerlessRuntimeData(document.RootElement);
            return new InformaticaServerlessRuntimeResource(_client, data);
        }
    }
}
