// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.InformaticaDataManagement
{
    internal class InformaticaOrganizationOperationSource : IOperationSource<InformaticaOrganizationResource>
    {
        private readonly ArmClient _client;

        internal InformaticaOrganizationOperationSource(ArmClient client)
        {
            _client = client;
        }

        InformaticaOrganizationResource IOperationSource<InformaticaOrganizationResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = InformaticaOrganizationData.DeserializeInformaticaOrganizationData(document.RootElement);
            return new InformaticaOrganizationResource(_client, data);
        }

        async ValueTask<InformaticaOrganizationResource> IOperationSource<InformaticaOrganizationResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = InformaticaOrganizationData.DeserializeInformaticaOrganizationData(document.RootElement);
            return new InformaticaOrganizationResource(_client, data);
        }
    }
}
