// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.InformaticaDataManagement.Models;

namespace Azure.ResourceManager.InformaticaDataManagement
{
    /// <summary>
    /// A Class representing an InformaticaServerlessRuntime along with the instance operations that can be performed on it.
    /// If you have a <see cref="ResourceIdentifier"/> you can construct an <see cref="InformaticaServerlessRuntimeResource"/>
    /// from an instance of <see cref="ArmClient"/> using the GetInformaticaServerlessRuntimeResource method.
    /// Otherwise you can get one from its parent resource <see cref="InformaticaOrganizationResource"/> using the GetInformaticaServerlessRuntime method.
    /// </summary>
    public partial class InformaticaServerlessRuntimeResource : ArmResource
    {
        /// <summary> Generate the resource identifier of a <see cref="InformaticaServerlessRuntimeResource"/> instance. </summary>
        /// <param name="subscriptionId"> The subscriptionId. </param>
        /// <param name="resourceGroupName"> The resourceGroupName. </param>
        /// <param name="organizationName"> The organizationName. </param>
        /// <param name="serverlessRuntimeName"> The serverlessRuntimeName. </param>
        public static ResourceIdentifier CreateResourceIdentifier(string subscriptionId, string resourceGroupName, string organizationName, string serverlessRuntimeName)
        {
            var resourceId = $"/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Informatica.DataManagement/organizations/{organizationName}/serverlessRuntimes/{serverlessRuntimeName}";
            return new ResourceIdentifier(resourceId);
        }

        private readonly ClientDiagnostics _informaticaServerlessRuntimeServerlessRuntimesClientDiagnostics;
        private readonly ServerlessRuntimesRestOperations _informaticaServerlessRuntimeServerlessRuntimesRestClient;
        private readonly InformaticaServerlessRuntimeData _data;

        /// <summary> Gets the resource type for the operations. </summary>
        public static readonly ResourceType ResourceType = "Informatica.DataManagement/organizations/serverlessRuntimes";

        /// <summary> Initializes a new instance of the <see cref="InformaticaServerlessRuntimeResource"/> class for mocking. </summary>
        protected InformaticaServerlessRuntimeResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="InformaticaServerlessRuntimeResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="data"> The resource that is the target of operations. </param>
        internal InformaticaServerlessRuntimeResource(ArmClient client, InformaticaServerlessRuntimeData data) : this(client, data.Id)
        {
            HasData = true;
            _data = data;
        }

        /// <summary> Initializes a new instance of the <see cref="InformaticaServerlessRuntimeResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal InformaticaServerlessRuntimeResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _informaticaServerlessRuntimeServerlessRuntimesClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.InformaticaDataManagement", ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ResourceType, out string informaticaServerlessRuntimeServerlessRuntimesApiVersion);
            _informaticaServerlessRuntimeServerlessRuntimesRestClient = new ServerlessRuntimesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, informaticaServerlessRuntimeServerlessRuntimesApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        /// <summary> Gets whether or not the current instance has data. </summary>
        public virtual bool HasData { get; }

        /// <summary> Gets the data representing this Feature. </summary>
        /// <exception cref="InvalidOperationException"> Throws if there is no data loaded in the current instance. </exception>
        public virtual InformaticaServerlessRuntimeData Data
        {
            get
            {
                if (!HasData)
                    throw new InvalidOperationException("The current instance does not have data, you must call Get first.");
                return _data;
            }
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceType), nameof(id));
        }

        /// <summary>
        /// Get a InformaticaServerlessRuntimeResource
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Informatica.DataManagement/organizations/{organizationName}/serverlessRuntimes/{serverlessRuntimeName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>InformaticaServerlessRuntimeResource_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-05-08</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="InformaticaServerlessRuntimeResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<InformaticaServerlessRuntimeResource>> GetAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _informaticaServerlessRuntimeServerlessRuntimesClientDiagnostics.CreateScope("InformaticaServerlessRuntimeResource.Get");
            scope.Start();
            try
            {
                var response = await _informaticaServerlessRuntimeServerlessRuntimesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new InformaticaServerlessRuntimeResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a InformaticaServerlessRuntimeResource
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Informatica.DataManagement/organizations/{organizationName}/serverlessRuntimes/{serverlessRuntimeName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>InformaticaServerlessRuntimeResource_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-05-08</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="InformaticaServerlessRuntimeResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<InformaticaServerlessRuntimeResource> Get(CancellationToken cancellationToken = default)
        {
            using var scope = _informaticaServerlessRuntimeServerlessRuntimesClientDiagnostics.CreateScope("InformaticaServerlessRuntimeResource.Get");
            scope.Start();
            try
            {
                var response = _informaticaServerlessRuntimeServerlessRuntimesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new InformaticaServerlessRuntimeResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Delete a InformaticaServerlessRuntimeResource
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Informatica.DataManagement/organizations/{organizationName}/serverlessRuntimes/{serverlessRuntimeName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>InformaticaServerlessRuntimeResource_Delete</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-05-08</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="InformaticaServerlessRuntimeResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<ArmOperation> DeleteAsync(WaitUntil waitUntil, CancellationToken cancellationToken = default)
        {
            using var scope = _informaticaServerlessRuntimeServerlessRuntimesClientDiagnostics.CreateScope("InformaticaServerlessRuntimeResource.Delete");
            scope.Start();
            try
            {
                var response = await _informaticaServerlessRuntimeServerlessRuntimesRestClient.DeleteAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, cancellationToken).ConfigureAwait(false);
                var operation = new InformaticaDataManagementArmOperation(_informaticaServerlessRuntimeServerlessRuntimesClientDiagnostics, Pipeline, _informaticaServerlessRuntimeServerlessRuntimesRestClient.CreateDeleteRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionResponseAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Delete a InformaticaServerlessRuntimeResource
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Informatica.DataManagement/organizations/{organizationName}/serverlessRuntimes/{serverlessRuntimeName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>InformaticaServerlessRuntimeResource_Delete</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-05-08</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="InformaticaServerlessRuntimeResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual ArmOperation Delete(WaitUntil waitUntil, CancellationToken cancellationToken = default)
        {
            using var scope = _informaticaServerlessRuntimeServerlessRuntimesClientDiagnostics.CreateScope("InformaticaServerlessRuntimeResource.Delete");
            scope.Start();
            try
            {
                var response = _informaticaServerlessRuntimeServerlessRuntimesRestClient.Delete(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, cancellationToken);
                var operation = new InformaticaDataManagementArmOperation(_informaticaServerlessRuntimeServerlessRuntimesClientDiagnostics, Pipeline, _informaticaServerlessRuntimeServerlessRuntimesRestClient.CreateDeleteRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletionResponse(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Update a InformaticaServerlessRuntimeResource
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Informatica.DataManagement/organizations/{organizationName}/serverlessRuntimes/{serverlessRuntimeName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>InformaticaServerlessRuntimeResource_Update</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-05-08</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="InformaticaServerlessRuntimeResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="patch"> The resource properties to be updated. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="patch"/> is null. </exception>
        public virtual async Task<Response<InformaticaServerlessRuntimeResource>> UpdateAsync(InformaticaServerlessRuntimePatch patch, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(patch, nameof(patch));

            using var scope = _informaticaServerlessRuntimeServerlessRuntimesClientDiagnostics.CreateScope("InformaticaServerlessRuntimeResource.Update");
            scope.Start();
            try
            {
                var response = await _informaticaServerlessRuntimeServerlessRuntimesRestClient.UpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, patch, cancellationToken).ConfigureAwait(false);
                return Response.FromValue(new InformaticaServerlessRuntimeResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Update a InformaticaServerlessRuntimeResource
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Informatica.DataManagement/organizations/{organizationName}/serverlessRuntimes/{serverlessRuntimeName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>InformaticaServerlessRuntimeResource_Update</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-05-08</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="InformaticaServerlessRuntimeResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="patch"> The resource properties to be updated. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="patch"/> is null. </exception>
        public virtual Response<InformaticaServerlessRuntimeResource> Update(InformaticaServerlessRuntimePatch patch, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(patch, nameof(patch));

            using var scope = _informaticaServerlessRuntimeServerlessRuntimesClientDiagnostics.CreateScope("InformaticaServerlessRuntimeResource.Update");
            scope.Start();
            try
            {
                var response = _informaticaServerlessRuntimeServerlessRuntimesRestClient.Update(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, patch, cancellationToken);
                return Response.FromValue(new InformaticaServerlessRuntimeResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks all dependencies for a serverless runtime resource
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Informatica.DataManagement/organizations/{organizationName}/serverlessRuntimes/{serverlessRuntimeName}/checkDependencies</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ServerlessRuntimes_CheckDependencies</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-05-08</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="InformaticaServerlessRuntimeResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<CheckDependenciesResult>> CheckDependenciesAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _informaticaServerlessRuntimeServerlessRuntimesClientDiagnostics.CreateScope("InformaticaServerlessRuntimeResource.CheckDependencies");
            scope.Start();
            try
            {
                var response = await _informaticaServerlessRuntimeServerlessRuntimesRestClient.CheckDependenciesAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks all dependencies for a serverless runtime resource
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Informatica.DataManagement/organizations/{organizationName}/serverlessRuntimes/{serverlessRuntimeName}/checkDependencies</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ServerlessRuntimes_CheckDependencies</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-05-08</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="InformaticaServerlessRuntimeResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<CheckDependenciesResult> CheckDependencies(CancellationToken cancellationToken = default)
        {
            using var scope = _informaticaServerlessRuntimeServerlessRuntimesClientDiagnostics.CreateScope("InformaticaServerlessRuntimeResource.CheckDependencies");
            scope.Start();
            try
            {
                var response = _informaticaServerlessRuntimeServerlessRuntimesRestClient.CheckDependencies(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Starts a failed runtime resource
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Informatica.DataManagement/organizations/{organizationName}/serverlessRuntimes/{serverlessRuntimeName}/startFailedServerlessRuntime</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ServerlessRuntimes_StartFailedServerlessRuntime</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-05-08</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="InformaticaServerlessRuntimeResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response> StartFailedServerlessRuntimeAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _informaticaServerlessRuntimeServerlessRuntimesClientDiagnostics.CreateScope("InformaticaServerlessRuntimeResource.StartFailedServerlessRuntime");
            scope.Start();
            try
            {
                var response = await _informaticaServerlessRuntimeServerlessRuntimesRestClient.StartFailedServerlessRuntimeAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Starts a failed runtime resource
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Informatica.DataManagement/organizations/{organizationName}/serverlessRuntimes/{serverlessRuntimeName}/startFailedServerlessRuntime</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ServerlessRuntimes_StartFailedServerlessRuntime</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-05-08</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="InformaticaServerlessRuntimeResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response StartFailedServerlessRuntime(CancellationToken cancellationToken = default)
        {
            using var scope = _informaticaServerlessRuntimeServerlessRuntimesClientDiagnostics.CreateScope("InformaticaServerlessRuntimeResource.StartFailedServerlessRuntime");
            scope.Start();
            try
            {
                var response = _informaticaServerlessRuntimeServerlessRuntimesRestClient.StartFailedServerlessRuntime(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Returns a serverless runtime resource by ID
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Informatica.DataManagement/organizations/{organizationName}/serverlessRuntimes/{serverlessRuntimeName}/serverlessResourceById</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ServerlessRuntimes_GetServerlessResourceById</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-05-08</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="InformaticaServerlessRuntimeResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<InformaticaServerlessRuntimeResource>> GetServerlessResourceByIdAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _informaticaServerlessRuntimeServerlessRuntimesClientDiagnostics.CreateScope("InformaticaServerlessRuntimeResource.GetServerlessResourceById");
            scope.Start();
            try
            {
                var response = await _informaticaServerlessRuntimeServerlessRuntimesRestClient.GetServerlessResourceByIdAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, cancellationToken).ConfigureAwait(false);
                return Response.FromValue(new InformaticaServerlessRuntimeResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Returns a serverless runtime resource by ID
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Informatica.DataManagement/organizations/{organizationName}/serverlessRuntimes/{serverlessRuntimeName}/serverlessResourceById</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ServerlessRuntimes_GetServerlessResourceById</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-05-08</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="InformaticaServerlessRuntimeResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<InformaticaServerlessRuntimeResource> GetServerlessResourceById(CancellationToken cancellationToken = default)
        {
            using var scope = _informaticaServerlessRuntimeServerlessRuntimesClientDiagnostics.CreateScope("InformaticaServerlessRuntimeResource.GetServerlessResourceById");
            scope.Start();
            try
            {
                var response = _informaticaServerlessRuntimeServerlessRuntimesRestClient.GetServerlessResourceById(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, cancellationToken);
                return Response.FromValue(new InformaticaServerlessRuntimeResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
