// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.InformaticaDataManagement
{
    /// <summary>
    /// A class representing a collection of <see cref="InformaticaServerlessRuntimeResource"/> and their operations.
    /// Each <see cref="InformaticaServerlessRuntimeResource"/> in the collection will belong to the same instance of <see cref="InformaticaOrganizationResource"/>.
    /// To get an <see cref="InformaticaServerlessRuntimeCollection"/> instance call the GetInformaticaServerlessRuntimes method from an instance of <see cref="InformaticaOrganizationResource"/>.
    /// </summary>
    public partial class InformaticaServerlessRuntimeCollection : ArmCollection, IEnumerable<InformaticaServerlessRuntimeResource>, IAsyncEnumerable<InformaticaServerlessRuntimeResource>
    {
        private readonly ClientDiagnostics _informaticaServerlessRuntimeServerlessRuntimesClientDiagnostics;
        private readonly ServerlessRuntimesRestOperations _informaticaServerlessRuntimeServerlessRuntimesRestClient;

        /// <summary> Initializes a new instance of the <see cref="InformaticaServerlessRuntimeCollection"/> class for mocking. </summary>
        protected InformaticaServerlessRuntimeCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="InformaticaServerlessRuntimeCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal InformaticaServerlessRuntimeCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _informaticaServerlessRuntimeServerlessRuntimesClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.InformaticaDataManagement", InformaticaServerlessRuntimeResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(InformaticaServerlessRuntimeResource.ResourceType, out string informaticaServerlessRuntimeServerlessRuntimesApiVersion);
            _informaticaServerlessRuntimeServerlessRuntimesRestClient = new ServerlessRuntimesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, informaticaServerlessRuntimeServerlessRuntimesApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != InformaticaOrganizationResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, InformaticaOrganizationResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Create a InformaticaServerlessRuntimeResource
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Informatica.DataManagement/organizations/{organizationName}/serverlessRuntimes/{serverlessRuntimeName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>InformaticaServerlessRuntimeResource_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-05-08</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="InformaticaServerlessRuntimeResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="serverlessRuntimeName"> Name of the Serverless Runtime resource. </param>
        /// <param name="data"> Resource create parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="serverlessRuntimeName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="serverlessRuntimeName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<InformaticaServerlessRuntimeResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string serverlessRuntimeName, InformaticaServerlessRuntimeData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(serverlessRuntimeName, nameof(serverlessRuntimeName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _informaticaServerlessRuntimeServerlessRuntimesClientDiagnostics.CreateScope("InformaticaServerlessRuntimeCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _informaticaServerlessRuntimeServerlessRuntimesRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, serverlessRuntimeName, data, cancellationToken).ConfigureAwait(false);
                var operation = new InformaticaDataManagementArmOperation<InformaticaServerlessRuntimeResource>(new InformaticaServerlessRuntimeOperationSource(Client), _informaticaServerlessRuntimeServerlessRuntimesClientDiagnostics, Pipeline, _informaticaServerlessRuntimeServerlessRuntimesRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, serverlessRuntimeName, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Create a InformaticaServerlessRuntimeResource
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Informatica.DataManagement/organizations/{organizationName}/serverlessRuntimes/{serverlessRuntimeName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>InformaticaServerlessRuntimeResource_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-05-08</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="InformaticaServerlessRuntimeResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="serverlessRuntimeName"> Name of the Serverless Runtime resource. </param>
        /// <param name="data"> Resource create parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="serverlessRuntimeName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="serverlessRuntimeName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<InformaticaServerlessRuntimeResource> CreateOrUpdate(WaitUntil waitUntil, string serverlessRuntimeName, InformaticaServerlessRuntimeData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(serverlessRuntimeName, nameof(serverlessRuntimeName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _informaticaServerlessRuntimeServerlessRuntimesClientDiagnostics.CreateScope("InformaticaServerlessRuntimeCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _informaticaServerlessRuntimeServerlessRuntimesRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, serverlessRuntimeName, data, cancellationToken);
                var operation = new InformaticaDataManagementArmOperation<InformaticaServerlessRuntimeResource>(new InformaticaServerlessRuntimeOperationSource(Client), _informaticaServerlessRuntimeServerlessRuntimesClientDiagnostics, Pipeline, _informaticaServerlessRuntimeServerlessRuntimesRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, serverlessRuntimeName, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a InformaticaServerlessRuntimeResource
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Informatica.DataManagement/organizations/{organizationName}/serverlessRuntimes/{serverlessRuntimeName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>InformaticaServerlessRuntimeResource_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-05-08</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="InformaticaServerlessRuntimeResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="serverlessRuntimeName"> Name of the Serverless Runtime resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="serverlessRuntimeName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="serverlessRuntimeName"/> is null. </exception>
        public virtual async Task<Response<InformaticaServerlessRuntimeResource>> GetAsync(string serverlessRuntimeName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(serverlessRuntimeName, nameof(serverlessRuntimeName));

            using var scope = _informaticaServerlessRuntimeServerlessRuntimesClientDiagnostics.CreateScope("InformaticaServerlessRuntimeCollection.Get");
            scope.Start();
            try
            {
                var response = await _informaticaServerlessRuntimeServerlessRuntimesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, serverlessRuntimeName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new InformaticaServerlessRuntimeResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a InformaticaServerlessRuntimeResource
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Informatica.DataManagement/organizations/{organizationName}/serverlessRuntimes/{serverlessRuntimeName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>InformaticaServerlessRuntimeResource_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-05-08</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="InformaticaServerlessRuntimeResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="serverlessRuntimeName"> Name of the Serverless Runtime resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="serverlessRuntimeName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="serverlessRuntimeName"/> is null. </exception>
        public virtual Response<InformaticaServerlessRuntimeResource> Get(string serverlessRuntimeName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(serverlessRuntimeName, nameof(serverlessRuntimeName));

            using var scope = _informaticaServerlessRuntimeServerlessRuntimesClientDiagnostics.CreateScope("InformaticaServerlessRuntimeCollection.Get");
            scope.Start();
            try
            {
                var response = _informaticaServerlessRuntimeServerlessRuntimesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, serverlessRuntimeName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new InformaticaServerlessRuntimeResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// List InformaticaServerlessRuntimeResource resources by InformaticaOrganizationResource
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Informatica.DataManagement/organizations/{organizationName}/serverlessRuntimes</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>InformaticaServerlessRuntimeResource_ListByInformaticaOrganizationResource</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-05-08</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="InformaticaServerlessRuntimeResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="InformaticaServerlessRuntimeResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<InformaticaServerlessRuntimeResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _informaticaServerlessRuntimeServerlessRuntimesRestClient.CreateListByInformaticaOrganizationResourceRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _informaticaServerlessRuntimeServerlessRuntimesRestClient.CreateListByInformaticaOrganizationResourceNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new InformaticaServerlessRuntimeResource(Client, InformaticaServerlessRuntimeData.DeserializeInformaticaServerlessRuntimeData(e)), _informaticaServerlessRuntimeServerlessRuntimesClientDiagnostics, Pipeline, "InformaticaServerlessRuntimeCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// List InformaticaServerlessRuntimeResource resources by InformaticaOrganizationResource
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Informatica.DataManagement/organizations/{organizationName}/serverlessRuntimes</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>InformaticaServerlessRuntimeResource_ListByInformaticaOrganizationResource</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-05-08</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="InformaticaServerlessRuntimeResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="InformaticaServerlessRuntimeResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<InformaticaServerlessRuntimeResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _informaticaServerlessRuntimeServerlessRuntimesRestClient.CreateListByInformaticaOrganizationResourceRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _informaticaServerlessRuntimeServerlessRuntimesRestClient.CreateListByInformaticaOrganizationResourceNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new InformaticaServerlessRuntimeResource(Client, InformaticaServerlessRuntimeData.DeserializeInformaticaServerlessRuntimeData(e)), _informaticaServerlessRuntimeServerlessRuntimesClientDiagnostics, Pipeline, "InformaticaServerlessRuntimeCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Informatica.DataManagement/organizations/{organizationName}/serverlessRuntimes/{serverlessRuntimeName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>InformaticaServerlessRuntimeResource_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-05-08</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="InformaticaServerlessRuntimeResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="serverlessRuntimeName"> Name of the Serverless Runtime resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="serverlessRuntimeName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="serverlessRuntimeName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string serverlessRuntimeName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(serverlessRuntimeName, nameof(serverlessRuntimeName));

            using var scope = _informaticaServerlessRuntimeServerlessRuntimesClientDiagnostics.CreateScope("InformaticaServerlessRuntimeCollection.Exists");
            scope.Start();
            try
            {
                var response = await _informaticaServerlessRuntimeServerlessRuntimesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, serverlessRuntimeName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Informatica.DataManagement/organizations/{organizationName}/serverlessRuntimes/{serverlessRuntimeName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>InformaticaServerlessRuntimeResource_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-05-08</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="InformaticaServerlessRuntimeResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="serverlessRuntimeName"> Name of the Serverless Runtime resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="serverlessRuntimeName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="serverlessRuntimeName"/> is null. </exception>
        public virtual Response<bool> Exists(string serverlessRuntimeName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(serverlessRuntimeName, nameof(serverlessRuntimeName));

            using var scope = _informaticaServerlessRuntimeServerlessRuntimesClientDiagnostics.CreateScope("InformaticaServerlessRuntimeCollection.Exists");
            scope.Start();
            try
            {
                var response = _informaticaServerlessRuntimeServerlessRuntimesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, serverlessRuntimeName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Informatica.DataManagement/organizations/{organizationName}/serverlessRuntimes/{serverlessRuntimeName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>InformaticaServerlessRuntimeResource_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-05-08</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="InformaticaServerlessRuntimeResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="serverlessRuntimeName"> Name of the Serverless Runtime resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="serverlessRuntimeName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="serverlessRuntimeName"/> is null. </exception>
        public virtual async Task<NullableResponse<InformaticaServerlessRuntimeResource>> GetIfExistsAsync(string serverlessRuntimeName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(serverlessRuntimeName, nameof(serverlessRuntimeName));

            using var scope = _informaticaServerlessRuntimeServerlessRuntimesClientDiagnostics.CreateScope("InformaticaServerlessRuntimeCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _informaticaServerlessRuntimeServerlessRuntimesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, serverlessRuntimeName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<InformaticaServerlessRuntimeResource>(response.GetRawResponse());
                return Response.FromValue(new InformaticaServerlessRuntimeResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Informatica.DataManagement/organizations/{organizationName}/serverlessRuntimes/{serverlessRuntimeName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>InformaticaServerlessRuntimeResource_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-05-08</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="InformaticaServerlessRuntimeResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="serverlessRuntimeName"> Name of the Serverless Runtime resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="serverlessRuntimeName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="serverlessRuntimeName"/> is null. </exception>
        public virtual NullableResponse<InformaticaServerlessRuntimeResource> GetIfExists(string serverlessRuntimeName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(serverlessRuntimeName, nameof(serverlessRuntimeName));

            using var scope = _informaticaServerlessRuntimeServerlessRuntimesClientDiagnostics.CreateScope("InformaticaServerlessRuntimeCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _informaticaServerlessRuntimeServerlessRuntimesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, serverlessRuntimeName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<InformaticaServerlessRuntimeResource>(response.GetRawResponse());
                return Response.FromValue(new InformaticaServerlessRuntimeResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<InformaticaServerlessRuntimeResource> IEnumerable<InformaticaServerlessRuntimeResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<InformaticaServerlessRuntimeResource> IAsyncEnumerable<InformaticaServerlessRuntimeResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
