// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.InformaticaDataManagement.Mocking
{
    /// <summary> A class to add extension methods to ResourceGroupResource. </summary>
    public partial class MockableInformaticaDataManagementResourceGroupResource : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableInformaticaDataManagementResourceGroupResource"/> class for mocking. </summary>
        protected MockableInformaticaDataManagementResourceGroupResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableInformaticaDataManagementResourceGroupResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableInformaticaDataManagementResourceGroupResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary> Gets a collection of InformaticaOrganizationResources in the ResourceGroupResource. </summary>
        /// <returns> An object representing collection of InformaticaOrganizationResources and their operations over a InformaticaOrganizationResource. </returns>
        public virtual InformaticaOrganizationCollection GetInformaticaOrganizations()
        {
            return GetCachedClient(client => new InformaticaOrganizationCollection(client, Id));
        }

        /// <summary>
        /// Get a InformaticaOrganizationResource
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Informatica.DataManagement/organizations/{organizationName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>InformaticaOrganizationResource_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-05-08</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="InformaticaOrganizationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="organizationName"> Name of the Organizations resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="organizationName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="organizationName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<InformaticaOrganizationResource>> GetInformaticaOrganizationAsync(string organizationName, CancellationToken cancellationToken = default)
        {
            return await GetInformaticaOrganizations().GetAsync(organizationName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Get a InformaticaOrganizationResource
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Informatica.DataManagement/organizations/{organizationName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>InformaticaOrganizationResource_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-05-08</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="InformaticaOrganizationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="organizationName"> Name of the Organizations resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="organizationName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="organizationName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<InformaticaOrganizationResource> GetInformaticaOrganization(string organizationName, CancellationToken cancellationToken = default)
        {
            return GetInformaticaOrganizations().Get(organizationName, cancellationToken);
        }
    }
}
